/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.LdapAuthenticationHandler;
import org.apereo.cas.authentication.handler.TenantAuthenticationHandlerBuilder;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthenticationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class TenantLdapAuthenticationHandlerBuilder
implements TenantAuthenticationHandlerBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantLdapAuthenticationHandlerBuilder.class);
    private final ConfigurableApplicationContext applicationContext;
    private final PrincipalFactory ldapPrincipalFactory;
    private final ServicesManager servicesManager;

    public List<AuthenticationHandler> buildInternal(TenantDefinition tenantDefinition, ConfigurationPropertiesBindingContext<CasConfigurationProperties> bindingContext) {
        if (bindingContext.containsBindingFor(LdapAuthenticationProperties.class)) {
            CasConfigurationProperties casProperties = (CasConfigurationProperties)bindingContext.value();
            return casProperties.getAuthn().getLdap().stream().filter(LdapUtils::isLdapAuthenticationConfigured).map(prop -> {
                LdapAuthenticationHandler handler = LdapUtils.createLdapAuthenticationHandler(prop, (ApplicationContext)this.applicationContext, this.servicesManager, this.ldapPrincipalFactory);
                handler.setState(prop.getState());
                LOGGER.info("Created LDAP authentication handler [{}] with state [{}]", (Object)handler.getName(), (Object)handler.getState());
                return handler.markDisposable();
            }).toList();
        }
        return List.of();
    }

    @Generated
    public TenantLdapAuthenticationHandlerBuilder(ConfigurableApplicationContext applicationContext, PrincipalFactory ldapPrincipalFactory, ServicesManager servicesManager) {
        this.applicationContext = applicationContext;
        this.ldapPrincipalFactory = ldapPrincipalFactory;
        this.servicesManager = servicesManager;
    }
}

