/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import java.util.function.Function;
import org.apereo.cas.monitor.MonitorableTask;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

@FunctionalInterface
public interface ExecutableObserver {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExecutableObserver.class);
    public static final String BEAN_NAME = "defaultExecutableObserver";

    default public void run(MonitorableTask task, Runnable runnable) {
    }

    public <T> T supply(MonitorableTask var1, CheckedSupplier<T> var2);

    public static void observe(ObjectProvider<ExecutableObserver> observerProvider, MonitorableTask task) {
        observerProvider.ifAvailable(observer -> observer.run(task, () -> {}));
    }

    public static Object observe(ObjectProvider<ExecutableObserver> observerProvider, ProceedingJoinPoint joinPoint, Function<MonitorableTask, MonitorableTask> taskCustomizer) throws Throwable {
        ExecutableObserver observer = (ExecutableObserver)observerProvider.getIfAvailable();
        if (observer != null) {
            MonitorableTask task = taskCustomizer.apply(MonitorableTask.from((JoinPoint)joinPoint));
            return observer.supply(task, () -> ExecutableObserver.executeJoinPoint(joinPoint));
        }
        return ExecutableObserver.executeJoinPoint(joinPoint);
    }

    public static Object observe(ObjectProvider<ExecutableObserver> observerProvider, ProceedingJoinPoint joinPoint) throws Throwable {
        return ExecutableObserver.observe(observerProvider, joinPoint, Function.identity());
    }

    private static Object executeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        LOGGER.trace("Executing [{}]", (Object)joinPoint.getStaticPart().toLongString());
        return joinPoint.proceed(args);
    }
}

