/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.ticket.TicketCatalogConfigurer;
import org.apereo.cas.ticket.catalog.CasTicketCatalogConfigurationValuesProvider;
import org.apereo.cas.ticket.catalog.DefaultTicketCatalogConfigurer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.TicketRegistry})
@Configuration(value="CasCoreTicketCatalogConfiguration", proxyBeanMethods=false)
class CasCoreTicketCatalogConfiguration {
    CasCoreTicketCatalogConfiguration() {
    }

    @ConditionalOnMissingBean(name={"casCoreTicketCatalogConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketCatalogConfigurer casCoreTicketCatalogConfigurer(CasConfigurationProperties casProperties, ObjectProvider<CasTicketCatalogConfigurationValuesProvider> valuesProvider, ConfigurableApplicationContext applicationContext) {
        return new DefaultTicketCatalogConfigurer(casProperties, applicationContext, valuesProvider);
    }
}

