/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import java.io.File;
import lombok.Generated;
import org.apereo.cas.util.io.PathWatcherService;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherService
extends PathWatcherService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileWatcherService.class);

    public FileWatcherService(File watchableFile, CheckedConsumer<File> onCreate, CheckedConsumer<File> onModify, CheckedConsumer<File> onDelete) {
        super(watchableFile.getParentFile().toPath(), FileWatcherService.getWatchedFileConsumer(watchableFile, onCreate), FileWatcherService.getWatchedFileConsumer(watchableFile, onModify), FileWatcherService.getWatchedFileConsumer(watchableFile, onDelete));
    }

    public FileWatcherService(File watchableFile, CheckedConsumer<File> onModify) {
        super(watchableFile.getParentFile(), FileWatcherService.getWatchedFileConsumer(watchableFile, onModify));
    }

    private static CheckedConsumer<File> getWatchedFileConsumer(File watchableFile, CheckedConsumer<File> consumer) {
        return file -> {
            if (file.getPath().equals(watchableFile.getPath())) {
                LOGGER.trace("Detected change in file [{}] and calling change consumer to handle event", file);
                CheckedConsumer.sneaky((CheckedConsumer)consumer).accept(file);
            }
        };
    }
}

