/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.DecodableCipherMap;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.springframework.context.ApplicationContext;

public class DecodableCipherExecutorMapModule
extends SimpleModule {
    private static final long serialVersionUID = 8418506749514188867L;
    private final ApplicationContext applicationContext;

    public void setupModule(Module.SetupContext setupContext) {
        final CipherExecutor cipherExecutor = ApplicationContextProvider.getBean(this.applicationContext, "casConfigurationCipherExecutor", CipherExecutor.class).orElseGet(CipherExecutor::noOp);
        setupContext.addBeanDeserializerModifier(new BeanDeserializerModifier(){
            private static final long serialVersionUID = 2351328333366612397L;

            public JsonDeserializer<?> modifyMapDeserializer(DeserializationConfig config, MapType type, BeanDescription beanDescription, JsonDeserializer jsonDeserializer) {
                return new DecryptingMapDeserializer(jsonDeserializer, cipherExecutor);
            }
        });
    }

    @Generated
    public DecodableCipherExecutorMapModule(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private static final class DecryptingMapDeserializer
    extends JsonDeserializer<Map<?, Object>>
    implements ContextualDeserializer,
    ResolvableDeserializer {
        private final JsonDeserializer<Map<?, ?>> defaultDeserializer;
        private final CipherExecutor cipherExecutor;

        public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
            JsonDeserializer<Map<?, ?>> jsonDeserializer = this.defaultDeserializer;
            if (jsonDeserializer instanceof ResolvableDeserializer) {
                ResolvableDeserializer deserializer = (ResolvableDeserializer)jsonDeserializer;
                deserializer.resolve(deserializationContext);
            }
        }

        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty property) throws JsonMappingException {
            JsonDeserializer jsonDeserializer;
            JsonDeserializer<Map<?, ?>> jsonDeserializer2 = this.defaultDeserializer;
            if (jsonDeserializer2 instanceof ContextualDeserializer) {
                ContextualDeserializer deserializer = (ContextualDeserializer)jsonDeserializer2;
                v0 = deserializer.createContextual(deserializationContext, property);
            } else {
                v0 = jsonDeserializer = this.defaultDeserializer;
            }
            if (property == null || property.getAnnotation(DecodableCipherMap.class) == null) {
                return jsonDeserializer;
            }
            return new DecryptingMapDeserializer(jsonDeserializer, this.cipherExecutor);
        }

        public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Map properties = (Map)this.defaultDeserializer.deserialize(jsonParser, deserializationContext);
            SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
            Map<String, String> effectiveMap = properties.entrySet().stream().collect(Collectors.toMap(entry -> resolver.resolve(entry.getKey().toString()), entry -> resolver.resolve(entry.getValue().toString())));
            return this.cipherExecutor.decode(effectiveMap, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }

        @Generated
        public DecryptingMapDeserializer(JsonDeserializer<Map<?, ?>> defaultDeserializer, CipherExecutor cipherExecutor) {
            this.defaultDeserializer = defaultDeserializer;
            this.cipherExecutor = cipherExecutor;
        }
    }
}

