/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.command.CommandArgs;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.form.FormProperty;
import org.apache.syncope.common.lib.form.FormPropertyValue;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.common.lib.to.AbstractStartEndBean;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.FormPropertyDefTO;
import org.apache.syncope.common.lib.to.InboundTaskTO;
import org.apache.syncope.common.lib.to.LiveSyncTaskTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.NotificationTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplateLiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.FormPropertyDef;
import org.apache.syncope.core.persistence.api.entity.task.InboundTask;
import org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.MacroTaskCommand;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.macro.MacroActions;
import org.apache.syncope.core.provisioning.java.data.AbstractExecutableDatabinder;
import org.apache.syncope.core.provisioning.java.job.MacroJobDelegate;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.pushpull.LiveSyncJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDataBinderImpl
extends AbstractExecutableDatabinder
implements TaskDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(TaskDataBinder.class);
    protected final RealmSearchDAO realmSearchDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final TaskExecDAO taskExecDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final ImplementationDAO implementationDAO;
    protected final EntityFactory entityFactory;
    protected final SyncopeTaskScheduler scheduler;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final TemplateUtils templateUtils;
    protected final Map<String, MacroActions> perContextMacroActions = new ConcurrentHashMap<String, MacroActions>();

    public TaskDataBinderImpl(RealmSearchDAO realmSearchDAO, ExternalResourceDAO resourceDAO, TaskExecDAO taskExecDAO, AnyTypeDAO anyTypeDAO, ImplementationDAO implementationDAO, EntityFactory entityFactory, SyncopeTaskScheduler scheduler, TaskUtilsFactory taskUtilsFactory, TemplateUtils templateUtils) {
        this.realmSearchDAO = realmSearchDAO;
        this.resourceDAO = resourceDAO;
        this.taskExecDAO = taskExecDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.implementationDAO = implementationDAO;
        this.entityFactory = entityFactory;
        this.scheduler = scheduler;
        this.taskUtilsFactory = taskUtilsFactory;
        this.templateUtils = templateUtils;
    }

    /*
     * Unable to fully structure code
     */
    protected void fill(ProvisioningTask<?> provisioningTask, ProvisioningTaskTO provisioningTaskTO) {
        block12: {
            block11: {
                if (!(provisioningTask instanceof PushTask)) break block11;
                pushTask = (PushTask)provisioningTask;
                if (!(provisioningTaskTO instanceof PushTaskTO)) break block11;
                pushTaskTO = (PushTaskTO)provisioningTaskTO;
                v0 = jobDelegate = pushTaskTO.getJobDelegate() == null ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter((Predicate<Implementation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$0(org.apache.syncope.core.persistence.api.entity.Implementation ), (Lorg/apache/syncope/core/persistence/api/entity/Implementation;)Z)()).findFirst().orElse(null) : (Implementation)this.implementationDAO.findById(pushTaskTO.getJobDelegate()).orElse(null);
                if (jobDelegate == null) {
                    jobDelegate = (Implementation)this.entityFactory.newEntity(Implementation.class);
                    jobDelegate.setKey(PushJobDelegate.class.getSimpleName());
                    jobDelegate.setEngine(ImplementationEngine.JAVA);
                    jobDelegate.setType("TASKJOB_DELEGATE");
                    jobDelegate.setBody(PushJobDelegate.class.getName());
                    jobDelegate = (Implementation)this.implementationDAO.save((Entity)jobDelegate);
                }
                pushTask.setJobDelegate(jobDelegate);
                pushTask.setSourceRealm((Realm)this.realmSearchDAO.findByFullPath(pushTaskTO.getSourceRealm()).orElseThrow((Supplier<NotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$fill$1(org.apache.syncope.common.lib.to.PushTaskTO ), ()Lorg/apache/syncope/core/persistence/api/dao/NotFoundException;)((PushTaskTO)pushTaskTO)));
                pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
                pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
                pushTaskTO.getFilters().forEach((BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$fill$2(org.apache.syncope.core.persistence.api.entity.task.PushTask java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((TaskDataBinderImpl)this, (PushTask)pushTask));
                pushTask.getFilters().entrySet().removeIf((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$5(org.apache.syncope.common.lib.to.PushTaskTO java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((PushTaskTO)pushTaskTO));
                break block12;
            }
            if (!(provisioningTask instanceof InboundTask)) break block12;
            inboundTask = (InboundTask)provisioningTask;
            if (!(provisioningTaskTO instanceof InboundTaskTO)) break block12;
            inboundTaskTO = (InboundTaskTO)provisioningTaskTO;
            inboundTask.setDestinationRealm((Realm)this.realmSearchDAO.findByFullPath(inboundTaskTO.getDestinationRealm()).orElseThrow((Supplier<NotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$fill$6(org.apache.syncope.common.lib.to.InboundTaskTO ), ()Lorg/apache/syncope/core/persistence/api/dao/NotFoundException;)((InboundTaskTO)inboundTaskTO)));
            inboundTask.setMatchingRule(inboundTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : inboundTaskTO.getMatchingRule());
            inboundTask.setUnmatchingRule(inboundTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : inboundTaskTO.getUnmatchingRule());
            inboundTask.setRemediation(inboundTaskTO.isRemediation());
            if (!(provisioningTask instanceof LiveSyncTask)) ** GOTO lbl-1000
            liveSyncTask = (LiveSyncTask)provisioningTask;
            if (provisioningTaskTO instanceof LiveSyncTaskTO) {
                liveSyncTaskTO = (LiveSyncTaskTO)provisioningTaskTO;
                v1 = jobDelegate = liveSyncTaskTO.getJobDelegate() == null ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter((Predicate<Implementation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$7(org.apache.syncope.core.persistence.api.entity.Implementation ), (Lorg/apache/syncope/core/persistence/api/entity/Implementation;)Z)()).findFirst().orElse(null) : (Implementation)this.implementationDAO.findById(liveSyncTaskTO.getJobDelegate()).orElse(null);
                if (jobDelegate == null) {
                    jobDelegate = (Implementation)this.entityFactory.newEntity(Implementation.class);
                    jobDelegate.setKey(LiveSyncJobDelegate.class.getSimpleName());
                    jobDelegate.setEngine(ImplementationEngine.JAVA);
                    jobDelegate.setType("TASKJOB_DELEGATE");
                    jobDelegate.setBody(LiveSyncJobDelegate.class.getName());
                    jobDelegate = (Implementation)this.implementationDAO.save((Entity)jobDelegate);
                }
                liveSyncTask.setJobDelegate(jobDelegate);
                liveSyncTask.setDelaySecondsAcrossInvocations(liveSyncTaskTO.getDelaySecondsAcrossInvocations());
                if (liveSyncTaskTO.getLiveSyncDeltaMapper() == null) {
                    liveSyncTask.setLiveSyncDeltaMapper(null);
                } else {
                    this.implementationDAO.findById(liveSyncTaskTO.getLiveSyncDeltaMapper()).ifPresentOrElse((Consumer<Implementation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setLiveSyncDeltaMapper(org.apache.syncope.core.persistence.api.entity.Implementation ), (Lorg/apache/syncope/core/persistence/api/entity/Implementation;)V)((LiveSyncTask)liveSyncTask), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$fill$8(org.apache.syncope.common.lib.to.LiveSyncTaskTO ), ()V)((LiveSyncTaskTO)liveSyncTaskTO));
                }
                this.templateUtils.check(liveSyncTaskTO.getTemplates(), ClientExceptionType.InvalidLiveSyncTask);
                liveSyncTaskTO.getTemplates().forEach((BiConsumer<String, AnyTO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$fill$9(org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask java.lang.String org.apache.syncope.common.lib.to.AnyTO ), (Ljava/lang/String;Lorg/apache/syncope/common/lib/to/AnyTO;)V)((TaskDataBinderImpl)this, (LiveSyncTask)liveSyncTask));
                liveSyncTask.getTemplates().removeIf((Predicate<AnyTemplateLiveSyncTask>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$12(org.apache.syncope.common.lib.to.LiveSyncTaskTO org.apache.syncope.core.persistence.api.entity.task.AnyTemplateLiveSyncTask ), (Lorg/apache/syncope/core/persistence/api/entity/task/AnyTemplateLiveSyncTask;)Z)((LiveSyncTaskTO)liveSyncTaskTO));
            } else if (provisioningTask instanceof PullTask) {
                pullTask = (PullTask)provisioningTask;
                if (provisioningTaskTO instanceof PullTaskTO) {
                    pullTaskTO = (PullTaskTO)provisioningTaskTO;
                    v2 = jobDelegate = pullTaskTO.getJobDelegate() == null ? (Implementation)this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter((Predicate<Implementation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$13(org.apache.syncope.core.persistence.api.entity.Implementation ), (Lorg/apache/syncope/core/persistence/api/entity/Implementation;)Z)()).findFirst().orElse(null) : (Implementation)this.implementationDAO.findById(pullTaskTO.getJobDelegate()).orElse(null);
                    if (jobDelegate == null) {
                        jobDelegate = (Implementation)this.entityFactory.newEntity(Implementation.class);
                        jobDelegate.setKey(PullJobDelegate.class.getSimpleName());
                        jobDelegate.setEngine(ImplementationEngine.JAVA);
                        jobDelegate.setType("TASKJOB_DELEGATE");
                        jobDelegate.setBody(PullJobDelegate.class.getName());
                        jobDelegate = (Implementation)this.implementationDAO.save((Entity)jobDelegate);
                    }
                    pullTask.setJobDelegate(jobDelegate);
                    pullTask.setPullMode(pullTaskTO.getPullMode());
                    if (pullTaskTO.getReconFilterBuilder() == null) {
                        pullTask.setReconFilterBuilder(null);
                    } else {
                        this.implementationDAO.findById(pullTaskTO.getReconFilterBuilder()).ifPresentOrElse((Consumer<Implementation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, setReconFilterBuilder(org.apache.syncope.core.persistence.api.entity.Implementation ), (Lorg/apache/syncope/core/persistence/api/entity/Implementation;)V)((PullTask)pullTask), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$fill$14(org.apache.syncope.common.lib.to.PullTaskTO ), ()V)((PullTaskTO)pullTaskTO));
                    }
                    this.templateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
                    pullTaskTO.getTemplates().forEach((BiConsumer<String, AnyTO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$fill$15(org.apache.syncope.core.persistence.api.entity.task.PullTask java.lang.String org.apache.syncope.common.lib.to.AnyTO ), (Ljava/lang/String;Lorg/apache/syncope/common/lib/to/AnyTO;)V)((TaskDataBinderImpl)this, (PullTask)pullTask));
                    pullTask.getTemplates().removeIf((Predicate<AnyTemplatePullTask>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$18(org.apache.syncope.common.lib.to.PullTaskTO org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask ), (Lorg/apache/syncope/core/persistence/api/entity/task/AnyTemplatePullTask;)Z)((PullTaskTO)pullTaskTO));
                }
            }
        }
        provisioningTask.setPerformCreate(provisioningTaskTO.isPerformCreate());
        provisioningTask.setPerformUpdate(provisioningTaskTO.isPerformUpdate());
        provisioningTask.setPerformDelete(provisioningTaskTO.isPerformDelete());
        provisioningTask.setSyncStatus(provisioningTaskTO.isSyncStatus());
        provisioningTaskTO.getActions().forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$fill$19(org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask java.lang.String ), (Ljava/lang/String;)V)((TaskDataBinderImpl)this, provisioningTask));
        provisioningTask.getActions().removeIf((Predicate<Implementation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fill$21(org.apache.syncope.common.lib.to.ProvisioningTaskTO org.apache.syncope.core.persistence.api.entity.Implementation ), (Lorg/apache/syncope/core/persistence/api/entity/Implementation;)Z)((ProvisioningTaskTO)provisioningTaskTO));
        provisioningTask.setConcurrentSettings(provisioningTaskTO.getConcurrentSettings());
    }

    protected void fill(MacroTask macroTask, MacroTaskTO macroTaskTO) {
        macroTask.setRealm((Realm)this.realmSearchDAO.findByFullPath(macroTaskTO.getRealm()).orElseThrow(() -> new NotFoundException("Realm " + macroTaskTO.getRealm())));
        macroTask.getCommands().clear();
        macroTaskTO.getCommands().forEach(command -> this.implementationDAO.findById(command.getKey()).ifPresentOrElse(impl -> {
            try {
                CommandArgs args = command.getArgs();
                if (args == null) {
                    args = ImplementationManager.emptyArgs((Implementation)impl);
                }
                MacroTaskCommand macroTaskCommand = (MacroTaskCommand)this.entityFactory.newEntity(MacroTaskCommand.class);
                macroTaskCommand.setCommand(impl);
                macroTaskCommand.setArgs(args);
                macroTaskCommand.setMacroTask(macroTask);
                macroTask.add(macroTaskCommand);
            }
            catch (Exception e) {
                LOG.error("While adding Command {} to Macro", (Object)impl.getKey(), (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementationType);
                sce.getElements().add("While adding Command " + impl.getKey() + ": " + e.getMessage());
                throw sce;
            }
        }, () -> LOG.error("Could not find Command {}", (Object)command.getKey())));
        macroTask.setContinueOnError(macroTaskTO.isContinueOnError());
        macroTask.setSaveExecs(macroTaskTO.isSaveExecs());
        macroTask.getFormPropertyDefs().clear();
        macroTaskTO.getFormPropertyDefs().forEach(fpdTO -> {
            FormPropertyDef fpd = (FormPropertyDef)this.entityFactory.newEntity(FormPropertyDef.class);
            fpd.setName(fpdTO.getName());
            fpd.getLabels().putAll(fpdTO.getLabels());
            fpd.setType(fpdTO.getType());
            fpd.setReadable(fpdTO.isReadable());
            fpd.setWritable(fpdTO.isWritable());
            fpd.setStringRegEx(fpdTO.getStringRegEx());
            fpd.setRequired(fpdTO.isRequired());
            fpd.setDatePattern(fpdTO.getDatePattern());
            fpd.setEnumValues(fpdTO.getEnumValues());
            fpd.setDropdownSingleSelection(fpdTO.isDropdownSingleSelection());
            fpd.setDropdownFreeForm(fpdTO.isDropdownFreeForm());
            fpd.setMimeType(fpdTO.getMimeType());
            fpd.setMacroTask(macroTask);
            macroTask.add(fpd);
        });
        if (macroTaskTO.getMacroActions() == null) {
            macroTask.setMacroAction(null);
        } else {
            this.implementationDAO.findById(macroTaskTO.getMacroActions()).ifPresentOrElse(arg_0 -> ((MacroTask)macroTask).setMacroAction(arg_0), () -> LOG.debug("Invalid Implementation {}, ignoring...", (Object)macroTaskTO.getMacroActions()));
        }
    }

    public SchedTask createSchedTask(SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.getType().getToClass();
        if (!taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("Expected %s, found %s", taskTOClass, taskTO.getClass()));
        }
        SchedTask task = (SchedTask)taskUtils.newTask();
        task.setCronExpression(taskTO.getCronExpression());
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setActive(taskTO.isActive());
        if (taskUtils.getType() == TaskType.SCHEDULED) {
            task.setJobDelegate((Implementation)this.implementationDAO.findById(taskTO.getJobDelegate()).orElseThrow(() -> new NotFoundException("JobDelegate " + taskTO.getJobDelegate())));
        } else if (taskTO instanceof MacroTaskTO) {
            MacroTaskTO macroTaskTO = (MacroTaskTO)taskTO;
            MacroTask macroTask = (MacroTask)task;
            Implementation jobDelegate = (macroTaskTO.getJobDelegate() == null ? this.implementationDAO.findByType("TASKJOB_DELEGATE").stream().filter(impl -> MacroJobDelegate.class.getName().equals(impl.getBody())).findFirst() : this.implementationDAO.findById(macroTaskTO.getJobDelegate())).orElse(null);
            if (jobDelegate == null) {
                jobDelegate = (Implementation)this.entityFactory.newEntity(Implementation.class);
                jobDelegate.setKey(MacroJobDelegate.class.getSimpleName());
                jobDelegate.setEngine(ImplementationEngine.JAVA);
                jobDelegate.setType("TASKJOB_DELEGATE");
                jobDelegate.setBody(MacroJobDelegate.class.getName());
                jobDelegate = (Implementation)this.implementationDAO.save((Entity)jobDelegate);
            }
            macroTask.setJobDelegate(jobDelegate);
            macroTask.setRealm((Realm)this.realmSearchDAO.findByFullPath(macroTaskTO.getRealm()).orElseThrow(() -> new NotFoundException("Realm " + macroTaskTO.getRealm())));
            this.fill(macroTask, macroTaskTO);
        } else if (taskTO instanceof ProvisioningTaskTO) {
            ProvisioningTaskTO provisioningTaskTO = (ProvisioningTaskTO)taskTO;
            ProvisioningTask provisioningTask = (ProvisioningTask)task;
            provisioningTask.setResource((ExternalResource)this.resourceDAO.findById(provisioningTaskTO.getResource()).orElseThrow(() -> new NotFoundException("Resource " + provisioningTaskTO.getResource())));
            this.fill(provisioningTask, provisioningTaskTO);
        }
        return task;
    }

    public void updateSchedTask(SchedTask task, SchedTaskTO taskTO, TaskUtils taskUtils) {
        Class taskTOClass = taskUtils.getType().getToClass();
        if (!taskTOClass.equals(taskTO.getClass())) {
            throw new IllegalArgumentException(String.format("Expected %s, found %s", taskTOClass, taskTO.getClass()));
        }
        if (StringUtils.isBlank((CharSequence)taskTO.getName())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("name");
            throw sce;
        }
        task.setName(taskTO.getName());
        task.setDescription(taskTO.getDescription());
        task.setCronExpression(taskTO.getCronExpression());
        task.setActive(taskTO.isActive());
        SchedTask schedTask = task;
        Objects.requireNonNull(schedTask);
        SchedTask schedTask2 = schedTask;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MacroTask.class, ProvisioningTask.class}, (Object)schedTask2, n)) {
            case 0: {
                MacroTask macroTask = (MacroTask)schedTask2;
                this.fill(macroTask, (MacroTaskTO)taskTO);
                break;
            }
            case 1: {
                ProvisioningTask provisioningTask = (ProvisioningTask)schedTask2;
                this.fill(provisioningTask, (ProvisioningTaskTO)taskTO);
                break;
            }
        }
    }

    public String buildRefDesc(Task<?> task) {
        return this.taskUtilsFactory.getInstance(task).getType().name() + " Task " + task.getKey() + " " + (task instanceof SchedTask ? ((SchedTask)SchedTask.class.cast(task)).getName() : (task instanceof PropagationTask ? ((PropagationTask)PropagationTask.class.cast(task)).getConnObjectKey() : ""));
    }

    public ExecTO getExecTO(TaskExec<?> execution) {
        ExecTO execTO = new ExecTO();
        execTO.setKey(execution.getKey());
        execTO.setStatus(execution.getStatus());
        execTO.setMessage(execution.getMessage());
        execTO.setStart(execution.getStart());
        execTO.setEnd(execution.getEnd());
        execTO.setExecutor(execution.getExecutor());
        if (execution.getTask() != null && execution.getTask().getKey() != null) {
            execTO.setJobType(JobType.TASK);
            execTO.setRefKey(execution.getTask().getKey());
            execTO.setRefDesc(this.buildRefDesc(execution.getTask()));
        }
        return execTO;
    }

    protected void fill(SchedTaskTO schedTaskTO, SchedTask schedTask) {
        schedTaskTO.setName(schedTask.getName());
        schedTaskTO.setDescription(schedTask.getDescription());
        schedTaskTO.setCronExpression(schedTask.getCronExpression());
        schedTaskTO.setActive(schedTask.isActive());
        schedTaskTO.setJobDelegate(schedTask.getJobDelegate().getKey());
        schedTaskTO.getExecutions().stream().max(Comparator.comparing(AbstractStartEndBean::getStart)).map(AbstractStartEndBean::getStart).ifPresentOrElse(arg_0 -> ((SchedTaskTO)schedTaskTO).setLastExec(arg_0), () -> schedTaskTO.setLastExec(schedTaskTO.getStart()));
        this.scheduler.getNextTrigger(AuthContextUtils.getDomain(), JobNamer.getJobName((Task)schedTask)).ifPresent(arg_0 -> ((SchedTaskTO)schedTaskTO).setNextExec(arg_0));
        if (schedTaskTO instanceof ProvisioningTaskTO) {
            ProvisioningTaskTO provisioningTaskTO = (ProvisioningTaskTO)schedTaskTO;
            if (schedTask instanceof ProvisioningTask) {
                ProvisioningTask provisioningTask = (ProvisioningTask)schedTask;
                provisioningTaskTO.setResource(provisioningTask.getResource().getKey());
                provisioningTaskTO.getActions().addAll(provisioningTask.getActions().stream().map(Entity::getKey).toList());
                provisioningTaskTO.setPerformCreate(provisioningTask.isPerformCreate());
                provisioningTaskTO.setPerformUpdate(provisioningTask.isPerformUpdate());
                provisioningTaskTO.setPerformDelete(provisioningTask.isPerformDelete());
                provisioningTaskTO.setSyncStatus(provisioningTask.isSyncStatus());
                provisioningTaskTO.setConcurrentSettings(provisioningTask.getConcurrentSettings());
            }
        }
    }

    public <T extends TaskTO> T getTaskTO(Task<?> task, TaskUtils taskUtils, boolean details) {
        TaskTO taskTO = taskUtils.newTaskTO();
        taskTO.setKey(task.getKey());
        this.taskExecDAO.findLatestStarted(taskUtils.getType(), task).ifPresentOrElse(latestExec -> {
            taskTO.setLatestExecStatus(latestExec.getStatus());
            taskTO.setStart(latestExec.getStart());
            taskTO.setEnd(latestExec.getEnd());
            taskTO.setLastExecutor(latestExec.getExecutor());
        }, () -> taskTO.setLatestExecStatus(""));
        if (details) {
            task.getExecs().stream().filter(Objects::nonNull).forEach(execution -> taskTO.getExecutions().add(this.getExecTO((TaskExec<?>)execution)));
        }
        switch (taskUtils.getType()) {
            case PROPAGATION: {
                PropagationTask propagationTask = (PropagationTask)task;
                PropagationTaskTO propagationTaskTO = (PropagationTaskTO)taskTO;
                propagationTaskTO.setOperation(propagationTask.getOperation());
                propagationTaskTO.setConnObjectKey(propagationTask.getConnObjectKey());
                propagationTaskTO.setOldConnObjectKey(propagationTask.getOldConnObjectKey());
                propagationTaskTO.setPropagationData(propagationTask.getSerializedPropagationData());
                propagationTaskTO.setResource(propagationTask.getResource().getKey());
                propagationTaskTO.setObjectClassName(propagationTask.getObjectClassName());
                propagationTaskTO.setAnyTypeKind(propagationTask.getAnyTypeKind());
                propagationTaskTO.setAnyType(propagationTask.getAnyType());
                propagationTaskTO.setEntityKey(propagationTask.getEntityKey());
                break;
            }
            case SCHEDULED: {
                SchedTask schedTask = (SchedTask)task;
                SchedTaskTO schedTaskTO = (SchedTaskTO)taskTO;
                this.fill(schedTaskTO, schedTask);
                break;
            }
            case MACRO: {
                MacroTask macroTask = (MacroTask)task;
                MacroTaskTO macroTaskTO = (MacroTaskTO)taskTO;
                this.fill((SchedTaskTO)macroTaskTO, (SchedTask)macroTask);
                macroTaskTO.setRealm(macroTask.getRealm().getFullPath());
                macroTask.getCommands().forEach(mct -> macroTaskTO.getCommands().add(new CommandTO.Builder(mct.getCommand().getKey()).args(mct.getArgs()).build()));
                macroTaskTO.setContinueOnError(macroTask.isContinueOnError());
                macroTaskTO.setSaveExecs(macroTask.isSaveExecs());
                macroTask.getFormPropertyDefs().forEach(fpd -> {
                    FormPropertyDefTO fpdTO = new FormPropertyDefTO();
                    fpdTO.setKey(fpd.getKey());
                    fpdTO.setName(fpd.getName());
                    fpdTO.getLabels().putAll(fpd.getLabels());
                    fpdTO.setType(fpd.getType());
                    fpdTO.setReadable(fpd.isReadable());
                    fpdTO.setWritable(fpd.isWritable());
                    fpdTO.setRequired(fpd.isRequired());
                    fpdTO.setStringRegEx(fpd.getStringRegEx());
                    fpdTO.setDatePattern(fpd.getDatePattern());
                    fpdTO.getEnumValues().putAll(fpd.getEnumValues());
                    fpdTO.setDropdownSingleSelection(fpd.isDropdownSingleSelection());
                    fpdTO.setDropdownFreeForm(fpd.isDropdownFreeForm());
                    fpdTO.setMimeType(fpd.getMimeType());
                    macroTaskTO.getFormPropertyDefs().add(fpdTO);
                });
                Optional.ofNullable(macroTask.getMacroActions()).ifPresent(fv -> macroTaskTO.setMacroActions(fv.getKey()));
                break;
            }
            case LIVE_SYNC: {
                LiveSyncTask liveSyncTask = (LiveSyncTask)task;
                LiveSyncTaskTO liveSyncTaskTO = (LiveSyncTaskTO)taskTO;
                this.fill((SchedTaskTO)liveSyncTaskTO, (SchedTask)liveSyncTask);
                liveSyncTaskTO.setDestinationRealm(liveSyncTask.getDestinationRealm().getFullPath());
                liveSyncTaskTO.setMatchingRule(liveSyncTask.getMatchingRule() == null ? MatchingRule.UPDATE : liveSyncTask.getMatchingRule());
                liveSyncTaskTO.setUnmatchingRule(liveSyncTask.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : liveSyncTask.getUnmatchingRule());
                liveSyncTaskTO.setDelaySecondsAcrossInvocations(liveSyncTask.getDelaySecondsAcrossInvocations());
                liveSyncTaskTO.setLiveSyncDeltaMapper(liveSyncTask.getLiveSyncDeltaMapper().getKey());
                liveSyncTask.getTemplates().forEach(template -> liveSyncTaskTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
                break;
            }
            case PULL: {
                PullTask pullTask = (PullTask)task;
                PullTaskTO pullTaskTO = (PullTaskTO)taskTO;
                this.fill((SchedTaskTO)pullTaskTO, (SchedTask)pullTask);
                pullTaskTO.setDestinationRealm(pullTask.getDestinationRealm().getFullPath());
                pullTaskTO.setMatchingRule(pullTask.getMatchingRule() == null ? MatchingRule.UPDATE : pullTask.getMatchingRule());
                pullTaskTO.setUnmatchingRule(pullTask.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTask.getUnmatchingRule());
                pullTaskTO.setPullMode(pullTask.getPullMode());
                Optional.ofNullable(pullTask.getReconFilterBuilder()).ifPresent(rfb -> pullTaskTO.setReconFilterBuilder(rfb.getKey()));
                pullTask.getTemplates().forEach(template -> pullTaskTO.getTemplates().put(template.getAnyType().getKey(), template.get()));
                pullTaskTO.setRemediation(pullTask.isRemediation());
                break;
            }
            case PUSH: {
                PushTask pushTask = (PushTask)task;
                PushTaskTO pushTaskTO = (PushTaskTO)taskTO;
                this.fill((SchedTaskTO)pushTaskTO, (SchedTask)pushTask);
                pushTaskTO.setSourceRealm(pushTask.getSourceRealm().getFullPath());
                pushTaskTO.setMatchingRule(pushTask.getMatchingRule() == null ? MatchingRule.LINK : pushTask.getMatchingRule());
                pushTaskTO.setUnmatchingRule(pushTask.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTask.getUnmatchingRule());
                pushTaskTO.getFilters().putAll(pushTask.getFilters());
                break;
            }
            case NOTIFICATION: {
                NotificationTask notificationTask = (NotificationTask)task;
                NotificationTaskTO notificationTaskTO = (NotificationTaskTO)taskTO;
                notificationTaskTO.setNotification(notificationTask.getNotification().getKey());
                notificationTaskTO.setAnyTypeKind(notificationTask.getAnyTypeKind());
                notificationTaskTO.setEntityKey(notificationTask.getEntityKey());
                notificationTaskTO.setSender(notificationTask.getSender());
                notificationTaskTO.getRecipients().addAll(notificationTask.getRecipients());
                notificationTaskTO.setSubject(notificationTask.getSubject());
                notificationTaskTO.setHtmlBody(notificationTask.getHtmlBody());
                notificationTaskTO.setTextBody(notificationTask.getTextBody());
                notificationTaskTO.setExecuted(notificationTask.isExecuted());
                if (notificationTask.isExecuted() && StringUtils.isBlank((CharSequence)taskTO.getLatestExecStatus())) {
                    taskTO.setLatestExecStatus("[EXECUTED]");
                }
                notificationTaskTO.setTraceLevel(notificationTask.getTraceLevel());
                break;
            }
        }
        return (T)taskTO;
    }

    public SyncopeForm getMacroTaskForm(MacroTask task, Locale locale) {
        Optional<Object> actions;
        if (task.getFormPropertyDefs().isEmpty()) {
            throw new NotFoundException("No form properties defined for MacroTask " + task.getKey());
        }
        if (task.getMacroActions() == null) {
            actions = Optional.empty();
        } else {
            try {
                actions = Optional.of((MacroActions)ImplementationManager.build((Implementation)task.getMacroActions(), () -> this.perContextMacroActions.get(task.getMacroActions().getKey()), instance -> this.perContextMacroActions.put(task.getMacroActions().getKey(), (MacroActions)instance)));
            }
            catch (Exception e) {
                LOG.error("Could not build {}", (Object)task.getMacroActions().getKey(), (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementation);
                sce.getElements().add("Could not build " + task.getMacroActions().getKey());
                throw sce;
            }
        }
        SyncopeForm form = new SyncopeForm();
        form.getProperties().addAll(task.getFormPropertyDefs().stream().map(fpd -> {
            FormProperty prop = new FormProperty();
            prop.setId(fpd.getName());
            prop.setName(fpd.getLabels().getOrDefault(locale, fpd.getName()));
            prop.setReadable(fpd.isReadable());
            prop.setRequired(fpd.isRequired());
            prop.setWritable(fpd.isWritable());
            prop.setType(fpd.getType());
            actions.flatMap(a -> a.getDefaultValue(fpd.getName())).ifPresent(arg_0 -> ((FormProperty)prop).setValue(arg_0));
            switch (prop.getType()) {
                case String: {
                    prop.setStringRegEx(fpd.getStringRegEx());
                    break;
                }
                case Date: {
                    prop.setDatePattern(fpd.getDatePattern());
                    break;
                }
                case Enum: {
                    fpd.getEnumValues().forEach((k, v) -> prop.getEnumValues().add(new FormPropertyValue(k, v)));
                    break;
                }
                case Dropdown: {
                    actions.ifPresent(a -> a.getDropdownValues(fpd.getName()).forEach((k, v) -> prop.getDropdownValues().add(new FormPropertyValue(k, v))));
                    prop.setDropdownSingleSelection(fpd.isDropdownSingleSelection());
                    prop.setDropdownFreeForm(fpd.isDropdownFreeForm());
                    break;
                }
                case Binary: {
                    prop.setMimeType(fpd.getMimeType());
                    break;
                }
            }
            return prop;
        }).toList());
        return form;
    }

    private static /* synthetic */ boolean lambda$fill$21(ProvisioningTaskTO provisioningTaskTO, Implementation impl) {
        return !provisioningTaskTO.getActions().contains(impl.getKey());
    }

    private /* synthetic */ void lambda$fill$19(ProvisioningTask provisioningTask, String action) {
        this.implementationDAO.findById(action).ifPresentOrElse(arg_0 -> ((ProvisioningTask)provisioningTask).add(arg_0), () -> LOG.debug("Invalid Implementation {}, ignoring...", (Object)action));
    }

    private static /* synthetic */ boolean lambda$fill$18(PullTaskTO pullTaskTO, AnyTemplatePullTask anyTemplate) {
        return !pullTaskTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey());
    }

    private /* synthetic */ void lambda$fill$15(PullTask pullTask, String type, AnyTO template) {
        this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> {
            AnyTemplatePullTask anyTemplate = pullTask.getTemplate(anyType.getKey()).orElse(null);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                anyTemplate.setAnyType(anyType);
                anyTemplate.setPullTask(pullTask);
                pullTask.add(anyTemplate);
            }
            anyTemplate.set(template);
        }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", (Object)type));
    }

    private static /* synthetic */ void lambda$fill$14(PullTaskTO pullTaskTO) {
        LOG.debug("Invalid Implementation {}, ignoring...", (Object)pullTaskTO.getReconFilterBuilder());
    }

    private static /* synthetic */ boolean lambda$fill$13(Implementation impl) {
        return PullJobDelegate.class.getSimpleName().equals(impl.getKey());
    }

    private static /* synthetic */ boolean lambda$fill$12(LiveSyncTaskTO liveSyncTaskTO, AnyTemplateLiveSyncTask anyTemplate) {
        return !liveSyncTaskTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey());
    }

    private /* synthetic */ void lambda$fill$9(LiveSyncTask liveSyncTask, String type, AnyTO template) {
        this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> {
            AnyTemplateLiveSyncTask anyTemplate = liveSyncTask.getTemplate(anyType.getKey()).orElse(null);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplateLiveSyncTask)this.entityFactory.newEntity(AnyTemplateLiveSyncTask.class);
                anyTemplate.setAnyType(anyType);
                anyTemplate.setLiveSyncTask(liveSyncTask);
                liveSyncTask.add(anyTemplate);
            }
            anyTemplate.set(template);
        }, () -> LOG.debug("Invalid AnyType {} specified, ignoring...", (Object)type));
    }

    private static /* synthetic */ void lambda$fill$8(LiveSyncTaskTO liveSyncTaskTO) {
        LOG.debug("Invalid Implementation {}, ignoring...", (Object)liveSyncTaskTO.getLiveSyncDeltaMapper());
    }

    private static /* synthetic */ boolean lambda$fill$7(Implementation impl) {
        return LiveSyncJobDelegate.class.getSimpleName().equals(impl.getKey());
    }

    private static /* synthetic */ NotFoundException lambda$fill$6(InboundTaskTO inboundTaskTO) {
        return new NotFoundException("Realm " + inboundTaskTO.getDestinationRealm());
    }

    private static /* synthetic */ boolean lambda$fill$5(PushTaskTO pushTaskTO, Map.Entry filter) {
        return !pushTaskTO.getFilters().containsKey(filter.getKey());
    }

    private /* synthetic */ void lambda$fill$2(PushTask pushTask, String type, String fiql) {
        this.anyTypeDAO.findById(type).ifPresentOrElse(anyType -> pushTask.getFilters().put(anyType.getKey(), fiql), () -> LOG.debug("Invalid AnyType {} specified, ignoring...", (Object)type));
    }

    private static /* synthetic */ NotFoundException lambda$fill$1(PushTaskTO pushTaskTO) {
        return new NotFoundException("Realm " + pushTaskTO.getSourceRealm());
    }

    private static /* synthetic */ boolean lambda$fill$0(Implementation impl) {
        return PushJobDelegate.class.getSimpleName().equals(impl.getKey());
    }
}

