/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.servlet.Filter;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.DefaultTenantExtractor;
import org.apereo.cas.multitenancy.DefaultTenantsManager;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.TenantRoutingFilter;
import org.apereo.cas.multitenancy.TenantWebflowDecorator;
import org.apereo.cas.multitenancy.TenantsManager;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.flow.decorator.WebflowDecorator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
@AutoConfiguration
public class CasCoreMultitenancyAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.multitenancy.core.enabled").isTrue();

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"tenantsManager"})
    public TenantsManager tenantsManager(@Qualifier(value="casConfigurationCipherExecutor") CipherExecutor<String, String> casConfigurationCipherExecutor, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (TenantsManager)BeanSupplier.of(TenantsManager.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            Resource location = casProperties.getMultitenancy().getJson().getLocation();
            ObjectMapper objectMapper = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).applicationContext(applicationContext).build().toObjectMapper();
            return new DefaultTenantsManager(objectMapper, location);
        }).otherwise(DefaultTenantsManager::new).get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"tenantExtractor"})
    public TenantExtractor tenantExtractor(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="tenantsManager") TenantsManager tenantsManager) {
        return new DefaultTenantExtractor(tenantsManager, (ApplicationContext)applicationContext, casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"casMultitenancyEndpointConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebSecurityConfigurer<HttpSecurity> casMultitenancyEndpointConfigurer() {
        return new CasWebSecurityConfigurer<HttpSecurity>(this){

            @CanIgnoreReturnValue
            public CasWebSecurityConfigurer<HttpSecurity> configure(HttpSecurity http) throws Exception {
                http.authorizeHttpRequests(customizer -> {
                    PathPatternRequestMatcher authEndpoints = PathPatternRequestMatcher.withDefaults().matcher("/tenants/**");
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{authEndpoints})).permitAll();
                });
                return this;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"casMultitenancyWebflowDecorator"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public WebflowDecorator casMultitenancyWebflowDecorator(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (WebflowDecorator)BeanSupplier.of(WebflowDecorator.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new TenantWebflowDecorator(tenantExtractor)).otherwise(WebflowDecorator::noOp).get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"tenantRoutingFilter"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public FilterRegistrationBean<TenantRoutingFilter> tenantRoutingFilter(ConfigurableApplicationContext applicationContext, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor) {
        FilterRegistrationBean fr = new FilterRegistrationBean();
        fr.setFilter((Filter)new TenantRoutingFilter(tenantExtractor));
        fr.addUrlPatterns(new String[]{"/*"});
        fr.setOrder(-2147483646);
        fr.setAsyncSupported(true);
        fr.setName("tenantRoutingFilter");
        fr.setEnabled(((Boolean)CONDITION.given((ApplicationContext)applicationContext).get()).booleanValue());
        return fr;
    }
}

