/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.delay;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.DelayParameters;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.distributed.remote.commands.CreateSnapshotCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

class DelayedCommandExecutor
implements CommandExecutor,
AsyncCommandExecutor {
    private static final int ORIGINAL_COMMAND_INDEX = 1;
    private static final int GET_SNAPSHOT_COMMAND_INDEX = 2;
    private final CommandExecutor originalExecutor;
    private final AsyncCommandExecutor originalAsyncExecutor;
    private final DelayParameters delayParameters;
    private final OptimizationListener listener;
    private final TimeMeter timeMeter;
    private RemoteBucketState state;
    private long lastSyncTimeNanos;
    private long postponedToConsumeTokens;

    DelayedCommandExecutor(CommandExecutor originalExecutor, DelayParameters delayParameters, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = originalExecutor;
        this.originalAsyncExecutor = null;
        this.delayParameters = delayParameters;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    DelayedCommandExecutor(AsyncCommandExecutor originalAsyncExecutor, DelayParameters delayParameters, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = null;
        this.originalAsyncExecutor = originalAsyncExecutor;
        this.delayParameters = delayParameters;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    @Override
    public <T> CommandResult<T> execute(RemoteCommand<T> command) {
        CommandResult<T> localResult = this.tryConsumeLocally(command);
        if (localResult != null) {
            this.listener.incrementSkipCount(1);
            return localResult;
        }
        MultiCommand remoteCommand = this.prepareRemoteCommand(command);
        CommandResult<MultiResult> commandResult = this.originalExecutor.execute(remoteCommand);
        this.rememberRemoteCommandResult(commandResult);
        return commandResult.isError() ? commandResult : commandResult.getData().getResults().get(1);
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
        CommandResult<T> result = this.tryConsumeLocally(command);
        if (result != null) {
            this.listener.incrementSkipCount(1);
            return CompletableFuture.completedFuture(result);
        }
        MultiCommand remoteCommand = this.prepareRemoteCommand(command);
        CompletableFuture<CommandResult<MultiResult>> resultFuture = this.originalAsyncExecutor.executeAsync(remoteCommand);
        return resultFuture.thenApply(remoteResult -> {
            this.rememberRemoteCommandResult((CommandResult<MultiResult>)remoteResult);
            return remoteResult.isError() ? remoteResult : ((MultiResult)remoteResult.getData()).getResults().get(1);
        });
    }

    private <T> CommandResult<T> tryConsumeLocally(RemoteCommand<T> command) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        if (this.isNeedToExecuteRemoteImmediately(command, currentTimeNanos)) {
            return null;
        }
        MutableBucketEntry entry = new MutableBucketEntry(this.state.copy());
        CommandResult<T> result = command.execute(entry, currentTimeNanos);
        if (result.isConfigurationNeedToBeReplaced()) {
            return null;
        }
        long locallyConsumedTokens = command.getConsumedTokens(result.getData());
        if (locallyConsumedTokens == Long.MAX_VALUE) {
            return null;
        }
        if (!this.isLocalExecutionResultSatisfiesThreshold(locallyConsumedTokens)) {
            return null;
        }
        this.postponedToConsumeTokens += locallyConsumedTokens;
        if (entry.isStateModified()) {
            this.state = entry.get();
        }
        return result;
    }

    private boolean isLocalExecutionResultSatisfiesThreshold(long locallyConsumedTokens) {
        if (locallyConsumedTokens == Long.MAX_VALUE || this.postponedToConsumeTokens + locallyConsumedTokens < 0L) {
            return false;
        }
        return this.postponedToConsumeTokens + locallyConsumedTokens <= this.delayParameters.maxUnsynchronizedTokens;
    }

    private <T> boolean isNeedToExecuteRemoteImmediately(RemoteCommand<T> command, long currentTimeNanos) {
        if (this.state == null) {
            return true;
        }
        if (currentTimeNanos - this.lastSyncTimeNanos > this.delayParameters.maxUnsynchronizedTimeoutNanos) {
            return true;
        }
        if (command.isImmediateSyncRequired(this.postponedToConsumeTokens, currentTimeNanos - this.lastSyncTimeNanos)) {
            return true;
        }
        long commandTokens = command.estimateTokensToConsume();
        if (commandTokens == Long.MAX_VALUE || commandTokens + this.postponedToConsumeTokens < 0L) {
            return true;
        }
        return commandTokens + this.postponedToConsumeTokens > this.delayParameters.maxUnsynchronizedTokens;
    }

    private <T> MultiCommand prepareRemoteCommand(RemoteCommand<T> command) {
        ArrayList commands = new ArrayList(3);
        commands.add(new ConsumeIgnoringRateLimitsCommand(this.postponedToConsumeTokens));
        commands.add(command);
        commands.add(new CreateSnapshotCommand());
        return new MultiCommand(commands);
    }

    private void rememberRemoteCommandResult(CommandResult<MultiResult> multiResult) {
        CommandResult<MultiResult> snapshotResult;
        this.postponedToConsumeTokens = 0L;
        this.lastSyncTimeNanos = this.timeMeter.currentTimeNanos();
        CommandResult<MultiResult> commandResult = snapshotResult = multiResult.isError() ? multiResult : multiResult.getData().getResults().get(2);
        if (snapshotResult.isError()) {
            this.state = null;
            return;
        }
        this.state = (RemoteBucketState)((Object)snapshotResult.getData());
    }
}

