/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.wizards.any.AnyObjectWrapper;
import org.apache.syncope.client.console.wizards.any.ConsoleAuxClasses;
import org.apache.syncope.client.console.wizards.any.DerAttrs;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.console.wizards.any.Groups;
import org.apache.syncope.client.console.wizards.any.Management;
import org.apache.syncope.client.console.wizards.any.PlainAttrs;
import org.apache.syncope.client.console.wizards.any.Relationships;
import org.apache.syncope.client.console.wizards.any.Roles;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.client.ui.commons.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractAnyWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.any.AnyForm;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;

public abstract class AnyWizardBuilder<A extends AnyTO>
extends AbstractAnyWizardBuilder<A> {
    private static final long serialVersionUID = -2480279868319546243L;
    private static final List<String> NO_VALUES = List.of("");
    protected final List<String> anyTypeClasses;
    protected AbstractAnyFormLayout<A, ? extends AnyForm<A>> formLayoutInfo;

    protected static <T extends AnyTO> AnyWrapper<T> wrapper(T anyTO) {
        Object object;
        if (anyTO instanceof UserTO) {
            UserTO userTO = (UserTO)anyTO;
            object = new UserWrapper(userTO);
        } else if (anyTO instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)anyTO;
            object = new GroupWrapper(groupTO);
        } else {
            object = new AnyObjectWrapper((AnyObjectTO)anyTO);
        }
        return object;
    }

    public AnyWizardBuilder(A anyTO, List<String> anyTypeClasses, AbstractAnyFormLayout<A, ? extends AnyForm<A>> formLayoutInfo, PageReference pageRef) {
        super(AnyWizardBuilder.wrapper(anyTO), pageRef);
        this.anyTypeClasses = anyTypeClasses;
        this.formLayoutInfo = formLayoutInfo;
    }

    public AnyWizardBuilder(AnyWrapper<A> wrapper, List<String> anyTypeClasses, AbstractAnyFormLayout<A, ? extends AnyForm<A>> formLayoutInfo, PageReference pageRef) {
        super(wrapper, pageRef);
        this.anyTypeClasses = anyTypeClasses;
        this.formLayoutInfo = formLayoutInfo;
    }

    protected WizardModel buildModelSteps(AnyWrapper<A> modelObject, WizardModel wizardModel) {
        this.addOptionalDetailsPanel(modelObject).ifPresent(arg_0 -> ((WizardModel)wizardModel).add(arg_0));
        if (this.formLayoutInfo.isAuxClasses()) {
            wizardModel.add((IWizardStep)new ConsoleAuxClasses(modelObject, this.anyTypeClasses));
        }
        if (this.formLayoutInfo.isGroups()) {
            wizardModel.add((IWizardStep)new Groups(modelObject, this.mode == AjaxWizard.Mode.TEMPLATE));
        }
        if (this.formLayoutInfo.isRelationships()) {
            wizardModel.add((IWizardStep)new Relationships(modelObject, this.pageRef));
        }
        if (this.formLayoutInfo.isPlainAttrs()) {
            wizardModel.add((IWizardStep)new PlainAttrs(modelObject, this.mode, this.anyTypeClasses, this.formLayoutInfo.getWhichPlainAttrs()){
                private static final long serialVersionUID = 8167894751609598306L;

                @Override
                public PageReference getPageReference() {
                    return AnyWizardBuilder.this.pageRef;
                }
            });
        }
        if (this.formLayoutInfo.isDerAttrs() && this.mode != AjaxWizard.Mode.TEMPLATE) {
            wizardModel.add((IWizardStep)new DerAttrs(modelObject, this.anyTypeClasses, this.formLayoutInfo.getWhichDerAttrs()));
        }
        if (this.formLayoutInfo.isManager()) {
            wizardModel.add((IWizardStep)new Management(modelObject, this.pageRef));
        }
        if (this instanceof UserWizardBuilder && modelObject instanceof UserWrapper) {
            UserFormLayoutInfo ufli;
            UserWrapper userWrapper = (UserWrapper)modelObject;
            AbstractAnyFormLayout<A, ? extends AnyForm<A>> abstractAnyFormLayout = this.formLayoutInfo;
            if (abstractAnyFormLayout instanceof UserFormLayoutInfo && (ufli = (UserFormLayoutInfo)abstractAnyFormLayout).isRoles()) {
                wizardModel.add((IWizardStep)new Roles(userWrapper));
            }
        }
        SyncopeWebApplication.get().getAnyWizardBuilderAdditionalSteps().buildModelSteps(modelObject, wizardModel, this.formLayoutInfo);
        return wizardModel;
    }

    protected Optional<Details<A>> addOptionalDetailsPanel(AnyWrapper<A> modelObject) {
        if (((AnyTO)modelObject.getInnerObject()).getKey() == null) {
            return Optional.empty();
        }
        return Optional.of(new Details<A>(modelObject, this.mode == AjaxWizard.Mode.TEMPLATE, true, this.pageRef));
    }

    protected void fixPlainAttrs(AnyTO updated, AnyTO original) {
        GroupableRelatableTO updatedTO;
        for (Attr plainAttr : original.getPlainAttrs()) {
            if (!updated.getPlainAttr(plainAttr.getSchema()).isEmpty()) continue;
            updated.getPlainAttrs().add(plainAttr);
        }
        if (updated instanceof GroupableRelatableTO) {
            updatedTO = (GroupableRelatableTO)updated;
            if (original instanceof GroupableRelatableTO) {
                GroupableRelatableTO originalTO = (GroupableRelatableTO)original;
                originalTO.getMemberships().forEach(oMemb -> updatedTO.getMembership(oMemb.getGroupKey()).ifPresent(uMemb -> oMemb.getPlainAttrs().stream().filter(attr -> uMemb.getPlainAttr(attr.getSchema()).isEmpty()).forEach(attr -> uMemb.getPlainAttrs().add(attr))));
                originalTO.getRelationships().forEach(oRel -> updatedTO.getRelationship(oRel.getType(), oRel.getOtherEndKey()).ifPresent(uRel -> oRel.getPlainAttrs().stream().filter(attr -> uRel.getPlainAttr(attr.getSchema()).isEmpty()).forEach(attr -> uRel.getPlainAttrs().add(attr))));
            }
        }
        updated.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty() || NO_VALUES.equals(attr.getValues()));
        if (updated instanceof GroupableRelatableTO) {
            updatedTO = (GroupableRelatableTO)updated;
            updatedTO.getMemberships().forEach(memb -> memb.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty() || NO_VALUES.equals(attr.getValues())));
            updatedTO.getRelationships().forEach(rel -> rel.getPlainAttrs().removeIf(attr -> attr.getValues().isEmpty() || NO_VALUES.equals(attr.getValues())));
        }
    }

    protected long getMaxWaitTimeInSeconds() {
        return SyncopeWebApplication.get().getMaxWaitTimeInSeconds();
    }

    protected void sendError(Exception exception) {
        SyncopeConsoleSession.get().onException(exception);
    }

    protected void sendWarning(String message) {
        SyncopeConsoleSession.get().warn((Serializable)((Object)message));
    }

    protected Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> future) {
        return SyncopeConsoleSession.get().execute(future);
    }
}

