/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BouncyCastleNonFIPSHelper {
    private BouncyCastleNonFIPSHelper() {
    }

    @NotNull
    public static ClassLoader getNonFIPSBouncyCastleClassLoader(boolean fallBackToDefaultClassLoader) throws ReflectiveOperationException {
        File serverRoot = InternalSDKHelper.getPingIdentityServerRoot();
        if (serverRoot == null) {
            if (fallBackToDefaultClassLoader) {
                return ClassLoader.getSystemClassLoader();
            }
            throw new ReflectiveOperationException(UtilityMessages.ERR_GET_NON_BC_FIPS_CLASS_LOADER_UNKNOWN_INSTANCE_ROOT.get());
        }
        ArrayList<URL> bcJarFileURLList = new ArrayList<URL>();
        File resourceBCNonFIPSDir = StaticUtils.constructPath(serverRoot, "resource", "bc", "non-fips");
        try {
            if (resourceBCNonFIPSDir.exists() && resourceBCNonFIPSDir.isDirectory()) {
                for (File f : resourceBCNonFIPSDir.listFiles()) {
                    if (!f.isFile() || !f.getName().toLowerCase().endsWith(".jar")) continue;
                    bcJarFileURLList.add(f.toURI().toURL());
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (fallBackToDefaultClassLoader) {
                return ClassLoader.getSystemClassLoader();
            }
            throw new ReflectiveOperationException(UtilityMessages.ERR_GET_NON_BC_FIPS_CLASS_LOADER_ERROR_FINDING_JARS.get(resourceBCNonFIPSDir.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        if (bcJarFileURLList.isEmpty()) {
            if (fallBackToDefaultClassLoader) {
                return ClassLoader.getSystemClassLoader();
            }
            throw new ReflectiveOperationException(UtilityMessages.ERR_GET_NON_FIPS_BC_CLASS_LOADER_NO_JARS_FOUND.get(resourceBCNonFIPSDir.getAbsolutePath()));
        }
        URL[] bcJarFileURLArray = new URL[bcJarFileURLList.size()];
        bcJarFileURLList.toArray(bcJarFileURLArray);
        return new URLClassLoader(bcJarFileURLArray, ClassLoader.getSystemClassLoader());
    }
}

