/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.common.ReflectionUtils;
import jakarta.persistence.AttributeConverter;
import java.util.HashMap;
import java.util.Map;

public abstract class CustomOrdinalEnumConverter<T extends Enum>
implements AttributeConverter<T, Integer> {
    private Map<Integer, T> customOrdinalValueToEnumMap = new HashMap<Integer, T>();

    public CustomOrdinalEnumConverter(Class<T> enumType) {
        Enum[] enumValues;
        for (Enum enumValue : enumValues = (Enum[])ReflectionUtils.invokeStaticMethod(ReflectionUtils.getMethod(enumType, "values", new Class[0]), new Object[0])) {
            Integer customOrdinalValue = (Integer)this.convertToDatabaseColumn(enumValue);
            this.customOrdinalValueToEnumMap.put(customOrdinalValue, enumValue);
        }
    }

    public T convertToEntityAttribute(Integer ordinalValue) {
        return (T)((Enum)this.customOrdinalValueToEnumMap.get(ordinalValue));
    }
}

