/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.codec.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.codec.Codec;
import org.springframework.util.Assert;

public abstract class AbstractKryoCodec
implements Codec {
    protected final Pool<Kryo> pool = new Pool<Kryo>(true, true){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(true);
            AbstractKryoCodec.this.configureKryoInstance(kryo);
            return kryo;
        }
    };

    protected AbstractKryoCodec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Object object, OutputStream outputStream) {
        Assert.notNull((Object)object, (String)"cannot encode a null object");
        Assert.notNull((Object)outputStream, (String)"'outputSteam' cannot be null");
        Kryo kryo = (Kryo)this.pool.obtain();
        try {
            Output castOutput;
            try (Output output = outputStream instanceof Output ? (castOutput = (Output)outputStream) : new Output(outputStream);){
                this.doEncode(kryo, object, output);
            }
        }
        finally {
            this.pool.free((Object)kryo);
        }
    }

    @Override
    public <T> T decode(byte[] bytes, Class<T> type) throws IOException {
        Assert.notNull((Object)bytes, (String)"'bytes' cannot be null");
        try (Input input = new Input(bytes);){
            T t = this.decode((InputStream)input, type);
            return t;
        }
    }

    @Override
    public <T> T decode(InputStream inputStream, Class<T> type) {
        Assert.notNull((Object)inputStream, (String)"'inputStream' cannot be null");
        Assert.notNull(type, (String)"'type' cannot be null");
        Kryo kryo = (Kryo)this.pool.obtain();
        try {
            T t;
            block9: {
                Input castInput;
                Input input = inputStream instanceof Input ? (castInput = (Input)inputStream) : new Input(inputStream);
                try {
                    t = this.doDecode(kryo, input, type);
                    if (input == null) break block9;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return t;
        }
        finally {
            this.pool.free((Object)kryo);
        }
    }

    @Override
    public byte[] encode(Object object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.encode(object, bos);
        byte[] bytes = bos.toByteArray();
        bos.close();
        return bytes;
    }

    protected abstract void doEncode(Kryo var1, Object var2, Output var3);

    protected abstract <T> T doDecode(Kryo var1, Input var2, Class<T> var3);

    protected abstract void configureKryoInstance(Kryo var1);
}

