/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.config.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.RouterFactoryBean;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.MethodInvokingRouter;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RouterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Router> {
    private static final String APPLY_SEQUENCE_ATTR = "applySequence";
    private static final String IGNORE_SEND_FAILURES_ATTR = "ignoreSendFailures";
    private static final String CHANNEL_MAPPINGS_ATTR = "channelMappings";
    private static final String RESOLUTION_REQUIRED_ATTR = "resolutionRequired";
    private static final String PREFIX_ATTR = "prefix";
    private static final String SUFFIX_ATTR = "suffix";

    public RouterAnnotationPostProcessor() {
        this.messageHandlerAttributes.addAll(Arrays.asList("defaultOutputChannel", APPLY_SEQUENCE_ATTR, IGNORE_SEND_FAILURES_ATTR, RESOLUTION_REQUIRED_ATTR, CHANNEL_MAPPINGS_ATTR, PREFIX_ATTR, SUFFIX_ATTR));
    }

    @Override
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotations) {
        BeanDefinition handlerBeanDefinition = super.resolveHandlerBeanDefinition(beanName, beanDefinition, handlerBeanType, annotations);
        if (handlerBeanDefinition != null) {
            return handlerBeanDefinition;
        }
        BeanDefinition targetObjectBeanDefinition = RouterAnnotationPostProcessor.buildLambdaMessageProcessor(handlerBeanType, beanDefinition);
        if (targetObjectBeanDefinition == null) {
            targetObjectBeanDefinition = new RuntimeBeanReference(beanName);
        }
        AbstractBeanDefinition routerBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(RouterFactoryBean.class).addPropertyValue("targetObject", (Object)targetObjectBeanDefinition).getBeanDefinition();
        new AbstractMethodAnnotationPostProcessor.BeanDefinitionPropertiesMapper((BeanDefinition)routerBeanDefinition, annotations).setPropertyValue(APPLY_SEQUENCE_ATTR).setPropertyValue(IGNORE_SEND_FAILURES_ATTR).setPropertyValue(RESOLUTION_REQUIRED_ATTR).setPropertyValue(PREFIX_ATTR).setPropertyValue(SUFFIX_ATTR);
        Object[] channelMappings = MessagingAnnotationUtils.resolveAttribute(annotations, CHANNEL_MAPPINGS_ATTR, String[].class);
        if (!ObjectUtils.isEmpty((Object[])channelMappings)) {
            Map<String, String> mappings = Arrays.stream(channelMappings).map(mapping -> {
                String[] keyValue = mapping.split("=");
                return Map.entry(keyValue[0], keyValue[1]);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            routerBeanDefinition.getPropertyValues().addPropertyValue(CHANNEL_MAPPINGS_ATTR, mappings);
        }
        return routerBeanDefinition;
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        String ignoreSendFailures;
        String applySequence;
        MethodInvokingRouter router = new MethodInvokingRouter(bean, method);
        String defaultOutputChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, "defaultOutputChannel", String.class);
        if (StringUtils.hasText((String)defaultOutputChannelName)) {
            ((AbstractMessageRouter)router).setDefaultOutputChannelName(defaultOutputChannelName);
        }
        if (StringUtils.hasText((String)(applySequence = MessagingAnnotationUtils.resolveAttribute(annotations, APPLY_SEQUENCE_ATTR, String.class)))) {
            router.setApplySequence(this.resolveAttributeToBoolean(applySequence));
        }
        if (StringUtils.hasText((String)(ignoreSendFailures = MessagingAnnotationUtils.resolveAttribute(annotations, IGNORE_SEND_FAILURES_ATTR, String.class)))) {
            router.setIgnoreSendFailures(this.resolveAttributeToBoolean(ignoreSendFailures));
        }
        this.routerAttributes(annotations, router);
        return router;
    }

    private void routerAttributes(List<Annotation> annotations, AbstractMessageRouter router) {
        if (this.routerAttributesProvided(annotations)) {
            Object[] channelMappings;
            String suffix;
            MethodInvokingRouter methodInvokingRouter = (MethodInvokingRouter)router;
            String resolutionRequired = MessagingAnnotationUtils.resolveAttribute(annotations, RESOLUTION_REQUIRED_ATTR, String.class);
            if (StringUtils.hasText((String)resolutionRequired)) {
                methodInvokingRouter.setResolutionRequired(this.resolveAttributeToBoolean(resolutionRequired));
            }
            ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
            String prefix = MessagingAnnotationUtils.resolveAttribute(annotations, PREFIX_ATTR, String.class);
            if (StringUtils.hasText((String)prefix)) {
                methodInvokingRouter.setPrefix(beanFactory.resolveEmbeddedValue(prefix));
            }
            if (StringUtils.hasText((String)(suffix = MessagingAnnotationUtils.resolveAttribute(annotations, SUFFIX_ATTR, String.class)))) {
                methodInvokingRouter.setSuffix(beanFactory.resolveEmbeddedValue(suffix));
            }
            if (!ObjectUtils.isEmpty((Object[])(channelMappings = MessagingAnnotationUtils.resolveAttribute(annotations, CHANNEL_MAPPINGS_ATTR, String[].class)))) {
                StringBuilder mappings = new StringBuilder();
                for (Object channelMapping : channelMappings) {
                    mappings.append((String)channelMapping).append("\n");
                }
                Properties properties = (Properties)this.getConversionService().convert((Object)mappings.toString(), TypeDescriptor.valueOf(String.class), TypeDescriptor.valueOf(Properties.class));
                methodInvokingRouter.replaceChannelMappings(properties);
            }
        }
    }

    private boolean routerAttributesProvided(List<Annotation> annotations) {
        String defaultOutputChannel = MessagingAnnotationUtils.resolveAttribute(annotations, "defaultOutputChannel", String.class);
        Object[] channelMappings = MessagingAnnotationUtils.resolveAttribute(annotations, CHANNEL_MAPPINGS_ATTR, String[].class);
        String prefix = MessagingAnnotationUtils.resolveAttribute(annotations, PREFIX_ATTR, String.class);
        String suffix = MessagingAnnotationUtils.resolveAttribute(annotations, SUFFIX_ATTR, String.class);
        String resolutionRequired = MessagingAnnotationUtils.resolveAttribute(annotations, RESOLUTION_REQUIRED_ATTR, String.class);
        String applySequence = MessagingAnnotationUtils.resolveAttribute(annotations, APPLY_SEQUENCE_ATTR, String.class);
        String ignoreSendFailures = MessagingAnnotationUtils.resolveAttribute(annotations, IGNORE_SEND_FAILURES_ATTR, String.class);
        return StringUtils.hasText((String)defaultOutputChannel) || !ObjectUtils.isEmpty((Object[])channelMappings) || StringUtils.hasText((String)prefix) || StringUtils.hasText((String)suffix) || StringUtils.hasText((String)resolutionRequired) || StringUtils.hasText((String)applySequence) || StringUtils.hasText((String)ignoreSendFailures);
    }
}

