/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.util.Optional;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.AnyCheck;

public class AnyValidator
extends AbstractValidator<AnyCheck, Any> {
    public boolean isValid(Any any, ConstraintValidatorContext context) {
        String plainSchema;
        context.disableDefaultConstraintViolation();
        if (any.getUManager() != null && any.getGManager() != null) {
            context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidManager, "Must either be managed by an user or by a group, not both")).addPropertyNode("manager").addConstraintViolation();
            return false;
        }
        AllowedSchemas allowedPlainSchemas = ((AnyUtilsFactory)ApplicationContextProvider.getApplicationContext().getBean(AnyUtilsFactory.class)).getInstance(any.getType().getKind()).dao().findAllowedSchemas(any, PlainSchema.class);
        for (PlainAttr attr : any.getPlainAttrs()) {
            String plainSchema2 = Optional.ofNullable(attr).map(PlainAttr::getSchema).orElse(null);
            if (plainSchema2 == null || allowedPlainSchemas.selfContains(plainSchema2)) continue;
            context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, plainSchema2 + " not allowed for this instance")).addPropertyNode("plainAttrs").addConstraintViolation();
            return false;
        }
        if (any instanceof Groupable) {
            Groupable groupable = (Groupable)any;
            for (Membership membership : groupable.getMemberships()) {
                for (PlainAttr attr : groupable.getPlainAttrs(membership)) {
                    plainSchema = Optional.ofNullable(attr).map(PlainAttr::getSchema).orElse(null);
                    if (plainSchema == null || allowedPlainSchemas.membershipsContains((Group)membership.getRightEnd(), plainSchema)) continue;
                    context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, plainSchema + " not allowed for membership of group " + ((Group)membership.getRightEnd()).getName())).addPropertyNode("plainAttrs").addConstraintViolation();
                    return false;
                }
            }
        }
        if (any instanceof Relatable) {
            Relatable relatable = (Relatable)any;
            for (Relationship relationship : relatable.getRelationships()) {
                for (PlainAttr attr : relatable.getPlainAttrs(relationship)) {
                    plainSchema = Optional.ofNullable(attr).map(PlainAttr::getSchema).orElse(null);
                    if (plainSchema == null || allowedPlainSchemas.relationshipTypesContains(relationship.getType(), plainSchema)) continue;
                    context.buildConstraintViolationWithTemplate(AnyValidator.getTemplate(EntityViolationType.InvalidPlainAttr, plainSchema + " not allowed for relationships of type " + relationship.getType().getKey())).addPropertyNode("plainAttrs").addConstraintViolation();
                    return false;
                }
            }
        }
        return true;
    }
}

