/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.to.AttributableTO;

public class RelationshipTO
implements BaseBean,
AttributableTO {
    private static final long serialVersionUID = 360672942026613929L;
    private String type;
    private End end;
    private String otherEndType;
    private String otherEndKey;
    private String otherEndName;
    private final Set<Attr> plainAttrs = new TreeSet<Attr>();
    private final Set<Attr> derAttrs = new TreeSet<Attr>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOtherEndType() {
        return this.otherEndType;
    }

    public void setOtherEndType(String otherEndType) {
        this.otherEndType = otherEndType;
    }

    public String getOtherEndKey() {
        return this.otherEndKey;
    }

    public void setOtherEndKey(String otherEndKey) {
        this.otherEndKey = otherEndKey;
    }

    public String getOtherEndName() {
        return this.otherEndName;
    }

    public void setOtherEndName(String otherEndName) {
        this.otherEndName = otherEndName;
    }

    public End getEnd() {
        return this.end;
    }

    public void setEnd(End end) {
        this.end = end;
    }

    @Override
    public Set<Attr> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    public Set<Attr> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getDerAttr(String schema) {
        return this.derAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.otherEndType).append((Object)this.otherEndKey).append((Object)this.otherEndName).append((Object)this.end).append(this.plainAttrs).append(this.derAttrs).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelationshipTO other = (RelationshipTO)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.otherEndType, (Object)other.otherEndType).append((Object)this.otherEndKey, (Object)other.otherEndKey).append((Object)this.otherEndName, (Object)other.otherEndName).append((Object)this.end, (Object)other.end).append(this.plainAttrs, other.plainAttrs).append(this.derAttrs, other.derAttrs).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append((Object)this.type).append((Object)this.end).append((Object)this.otherEndType).append((Object)this.otherEndKey).build();
    }

    public static enum End {
        LEFT,
        RIGHT;

    }

    public static class Builder {
        private final RelationshipTO instance = new RelationshipTO();

        public Builder(String type) {
            this.instance.setType(type);
            this.instance.setEnd(End.LEFT);
        }

        public Builder(String type, End end) {
            this.instance.setType(type);
            this.instance.setEnd(end);
        }

        public Builder otherEnd(String otherEndKey) {
            this.instance.setOtherEndKey(otherEndKey);
            return this;
        }

        public Builder otherEnd(String otherEndType, String otherEndKey) {
            this.instance.setOtherEndType(otherEndType);
            this.instance.setOtherEndKey(otherEndKey);
            return this;
        }

        public Builder otherEnd(String otherEndType, String otherEndKey, String otherEndName) {
            this.instance.setOtherEndType(otherEndType);
            this.instance.setOtherEndKey(otherEndKey);
            this.instance.setOtherEndName(otherEndName);
            return this;
        }

        public Builder plainAttr(Attr plainAttr) {
            this.instance.getPlainAttrs().add(plainAttr);
            return this;
        }

        public Builder plainAttrs(Attr ... plainAttrs) {
            this.instance.getPlainAttrs().addAll(List.of(plainAttrs));
            return this;
        }

        public Builder plainAttrs(Collection<Attr> plainAttrs) {
            this.instance.getPlainAttrs().addAll(plainAttrs);
            return this;
        }

        public RelationshipTO build() {
            return this.instance;
        }
    }
}

