/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import org.apereo.cas.ticket.DefaultTicketDefinition;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.util.function.FunctionUtils;

public abstract class BaseTicketCatalogConfigurer
implements TicketCatalogConfigurer {
    protected TicketDefinition buildTicketDefinition(TicketCatalog plan, String prefix, Class<? extends Ticket> api, Class<? extends Ticket> impl, int order) {
        if (plan.contains(prefix)) {
            return plan.find(prefix);
        }
        return new DefaultTicketDefinition(impl, api, prefix, order);
    }

    protected TicketDefinition buildTicketDefinition(TicketCatalog plan, String prefix, Class impl, Class api) throws Throwable {
        if (plan.contains(prefix)) {
            return plan.find(prefix);
        }
        FunctionUtils.throwIf((!api.isInterface() ? 1 : 0) != 0, () -> new IllegalArgumentException("Ticket API class %s must be an interface".formatted(api.getName())));
        FunctionUtils.throwIf((boolean)impl.isInterface(), () -> new IllegalArgumentException("Ticket implementation class %s must be a concrete class".formatted(api.getName())));
        return new DefaultTicketDefinition(impl, api, prefix, Integer.MAX_VALUE);
    }

    protected void registerTicketDefinition(TicketCatalog plan, TicketDefinition ticketDefinition) {
        TicketDefinition result = this.customizeTicketDefinitionBeforeRegistration(ticketDefinition);
        plan.register(result);
    }

    protected TicketDefinition customizeTicketDefinitionBeforeRegistration(TicketDefinition ticketDefinition) {
        return ticketDefinition;
    }
}

