/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.google.common.io.ByteSource;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.support.events.logout.CasRequestSingleLogoutEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.EncodedTicket;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceAwareTicket;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.registry.DefaultEncodedTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractTicketRegistry
implements TicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTicketRegistry.class);
    private static final String TICKET_ENCRYPTION_LOG_MESSAGE = "Ticket encryption is not enabled. Falling back to default behavior";
    protected CipherExecutor cipherExecutor;
    protected final TicketSerializationManager ticketSerializationManager;
    protected final TicketCatalog ticketCatalog;
    protected final ApplicationContext applicationContext;

    protected static String getPrincipalIdFrom(Ticket ticket) {
        String string;
        if (ticket instanceof AuthenticationAwareTicket) {
            AuthenticationAwareTicket authenticationAwareTicket = (AuthenticationAwareTicket)ticket;
            string = Optional.ofNullable(authenticationAwareTicket.getAuthentication()).map(auth -> auth.getPrincipal().getId()).orElse("");
        } else {
            string = "";
        }
        return string;
    }

    protected Map collectAndDigestTicketAttributes(Ticket ticket) {
        Map<String, List<Object>> currentAttributes = AbstractTicketRegistry.getCombinedTicketAttributes(ticket);
        if (this.isCipherExecutorEnabled()) {
            HashMap encodedAttributes = new HashMap(currentAttributes.size());
            currentAttributes.forEach((key, value) -> {
                List<String> allValues = this.digestIdentifier((Collection<Object>)value);
                if (!allValues.isEmpty()) {
                    encodedAttributes.put(this.digestIdentifier((String)key), allValues);
                }
            });
            return encodedAttributes;
        }
        return currentAttributes;
    }

    private static Map<String, List<Object>> getCombinedTicketAttributes(Ticket ticket) {
        AuthenticationAwareTicket authnTicket;
        Authentication authentication;
        if (ticket instanceof AuthenticationAwareTicket && (authentication = (authnTicket = (AuthenticationAwareTicket)ticket).getAuthentication()) != null) {
            HashMap attributes = new HashMap(authentication.getAttributes());
            Principal principal = authentication.getPrincipal();
            return CoreAuthenticationUtils.mergeAttributes(attributes, (Map)principal.getAttributes());
        }
        return new HashMap<String, List<Object>>();
    }

    public Ticket addTicket(Ticket ticket) throws Exception {
        return ticket != null && !ticket.isExpired() ? this.addSingleTicket(ticket) : null;
    }

    public Ticket getTicket(String ticketId) {
        long ticketAgeSeconds;
        Ticket returnTicket = this.getTicket(ticketId, ticket -> {
            if (ticket.isExpired()) {
                TicketGrantingTicket tgt;
                long ticketAgeSeconds = AbstractTicketRegistry.getTicketAgeSeconds(ticket);
                LOGGER.debug("Ticket [{}] has expired according to policy [{}] after [{}] seconds and [{}] uses and will be removed from the ticket registry", new Object[]{ticketId, ticket.getExpirationPolicy().getName(), ticketAgeSeconds, ticket.getCountOfUses()});
                ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
                if (ticket instanceof TicketGrantingTicket) {
                    tgt = (TicketGrantingTicket)ticket;
                    this.applicationContext.publishEvent((ApplicationEvent)new CasRequestSingleLogoutEvent((Object)this, tgt, clientInfo));
                }
                try {
                    this.deleteTicket((Ticket)ticket);
                    if (ticket instanceof TicketGrantingTicket) {
                        tgt = (TicketGrantingTicket)ticket;
                        this.applicationContext.publishEvent((ApplicationEvent)new CasTicketGrantingTicketDestroyedEvent((Object)this, tgt, clientInfo));
                    }
                }
                catch (Exception e) {
                    LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
                }
                return false;
            }
            return true;
        });
        if (returnTicket != null && (ticketAgeSeconds = AbstractTicketRegistry.getTicketAgeSeconds(returnTicket)) < -1L) {
            LOGGER.warn("Ticket created [{}] second(s) in the future. Check time synchronization on all servers.", (Object)(ticketAgeSeconds * -1L));
        }
        return returnTicket;
    }

    public <T extends Ticket> T getTicket(String ticketId, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            LOGGER.debug("Ticket [{}] with type [{}] cannot be found", (Object)ticketId, (Object)clazz.getSimpleName());
            throw new InvalidTicketException(ticketId);
        }
        if (!clazz.isAssignableFrom(ticket.getClass())) {
            throw new ClassCastException("Ticket [" + ticket.getId() + " is of type " + String.valueOf(ticket.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)((Ticket)clazz.cast(ticket));
    }

    public int deleteTicket(String ticketId) throws Exception {
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            LOGGER.trace("No ticket id is provided for deletion");
            return 0;
        }
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            LOGGER.debug("Ticket [{}] could not be fetched from the registry; it may have been expired and deleted.", (Object)ticketId);
            return 0;
        }
        return this.deleteTicket(ticket);
    }

    public int deleteTicket(Ticket ticket) throws Exception {
        AtomicLong count = new AtomicLong(0L);
        if (ticket instanceof TicketGrantingTicket) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            LOGGER.debug("Removing children of ticket [{}] from the registry.", (Object)ticket.getId());
            count.getAndAdd(this.deleteChildren(tgt));
            if (ticket instanceof ProxyGrantingTicket) {
                ProxyGrantingTicket pgt = (ProxyGrantingTicket)ticket;
                this.deleteProxyGrantingTicketFromParent(pgt);
            } else {
                this.deleteLinkedProxyGrantingTickets(count, tgt);
            }
        }
        LOGGER.debug("Removing ticket [{}] from the registry.", (Object)ticket);
        count.getAndAdd(this.deleteSingleTicket(ticket));
        return count.intValue();
    }

    public long sessionCount() {
        long l;
        block8: {
            Stream<Ticket> tgtStream = this.stream().filter(TicketGrantingTicket.class::isInstance);
            try {
                l = tgtStream.count();
                if (tgtStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tgtStream != null) {
                        try {
                            tgtStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception t) {
                    LOGGER.trace("sessionCount() operation is not implemented by the ticket registry instance [{}]. Message is: [{}] Returning unknown as [{}]", new Object[]{this.getClass().getName(), t.getMessage(), Long.MIN_VALUE});
                    return Long.MIN_VALUE;
                }
            }
            tgtStream.close();
        }
        return l;
    }

    public long serviceTicketCount() {
        long l;
        block8: {
            Stream<Ticket> stStream = this.stream().filter(ServiceTicket.class::isInstance);
            try {
                l = stStream.count();
                if (stStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stStream != null) {
                        try {
                            stStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception t) {
                    LOGGER.trace("serviceTicketCount() operation is not implemented by the ticket registry instance [{}]. Message is: [{}] Returning unknown as [{}]", new Object[]{this.getClass().getName(), t.getMessage(), Long.MIN_VALUE});
                    return Long.MIN_VALUE;
                }
            }
            stStream.close();
        }
        return l;
    }

    public long countSessionsFor(String principalId) {
        Predicate<Ticket> ticketPredicate = t -> {
            if (t instanceof TicketGrantingTicket) {
                TicketGrantingTicket ticket = (TicketGrantingTicket)t;
                return ticket.getAuthentication().getPrincipal().getId().equalsIgnoreCase(principalId);
            }
            return false;
        };
        return this.getTickets(ticketPredicate).count();
    }

    public String digestIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return identifier;
        }
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(TICKET_ENCRYPTION_LOG_MESSAGE);
            return identifier;
        }
        String encodedId = DigestUtils.sha512((String)identifier);
        LOGGER.debug("Digested original ticket id [{}] to [{}]", (Object)identifier, (Object)encodedId);
        return encodedId;
    }

    protected List<String> digestIdentifier(Collection<Object> identifiers) {
        return identifiers.stream().map(Object::toString).map(this::digestIdentifier).collect(Collectors.toList());
    }

    public long countTicketsFor(Service service) {
        return this.stream().map(this::decodeTicket).filter(ServiceAwareTicket.class::isInstance).filter(ticket -> !ticket.isExpired()).map(ServiceAwareTicket.class::cast).filter(ticket -> Objects.nonNull(ticket.getService())).filter(ticket -> ticket.getService().getId().equals(service.getId())).count();
    }

    public Stream<? extends Ticket> getSessionsWithAttributes(Map<String, List<Object>> queryAttributes) {
        return this.getTickets(ticket -> {
            if (ticket instanceof TicketGrantingTicket) {
                TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ticket;
                if (!ticket.isExpired() && ticketGrantingTicket.getAuthentication() != null) {
                    Map attributes = this.collectAndDigestTicketAttributes((Ticket)ticketGrantingTicket);
                    return queryAttributes.entrySet().stream().anyMatch(queryEntry -> {
                        String attributeKey = this.digestIdentifier((String)queryEntry.getKey());
                        if (attributes.containsKey(attributeKey)) {
                            Set authnAttributeValues = CollectionUtils.toCollection(attributes.get(attributeKey));
                            return authnAttributeValues.stream().anyMatch(value -> {
                                String attributeValue = value.toString();
                                return ((List)queryEntry.getValue()).stream().map(queryValue -> this.digestIdentifier(queryValue.toString())).anyMatch(attributeValue::equalsIgnoreCase);
                            });
                        }
                        return false;
                    });
                }
            }
            return false;
        });
    }

    protected long deleteSingleTicket(Ticket ticket) {
        return 0L;
    }

    protected abstract Ticket addSingleTicket(Ticket var1) throws Exception;

    protected int deleteTickets(Set<String> tickets) {
        return this.deleteTickets(tickets.stream());
    }

    protected int deleteTickets(Stream<String> tickets) {
        return tickets.mapToInt(Unchecked.toIntFunction(this::deleteTicket)).sum();
    }

    protected int deleteChildren(TicketGrantingTicket ticket) {
        AtomicLong count = new AtomicLong(0L);
        Map services = ticket.getServices();
        if (services != null && !services.isEmpty()) {
            services.keySet().stream().map(this::getTicket).filter(Objects::nonNull).forEach(serviceTicket -> {
                long deleteCount = this.deleteSingleTicket((Ticket)serviceTicket);
                if (deleteCount > 0L) {
                    LOGGER.debug("Removed ticket [{}]", (Object)serviceTicket.getId());
                    count.getAndAdd(deleteCount);
                } else {
                    LOGGER.debug("Unable to remove ticket [{}]", (Object)serviceTicket.getId());
                }
            });
        }
        return count.intValue();
    }

    protected Ticket encodeTicket(Ticket ticket) throws Exception {
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(TICKET_ENCRYPTION_LOG_MESSAGE);
            return ticket;
        }
        if (ticket == null) {
            LOGGER.debug("Ticket passed is null and cannot be encoded");
            return null;
        }
        Ticket encodedTicket = this.createEncodedTicket(ticket);
        LOGGER.debug("Created encoded ticket [{}]", (Object)encodedTicket);
        return encodedTicket;
    }

    protected Ticket decodeTicket(Ticket ticketToProcess) {
        if (ticketToProcess instanceof EncodedTicket && !this.isCipherExecutorEnabled()) {
            LOGGER.warn("Found removable encoded ticket [{}] yet cipher operations are disabled.", (Object)ticketToProcess.getId());
            FunctionUtils.doUnchecked(__ -> this.deleteTicket(ticketToProcess), (Object[])new Object[0]);
            return null;
        }
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(TICKET_ENCRYPTION_LOG_MESSAGE);
            return ticketToProcess;
        }
        if (ticketToProcess == null) {
            LOGGER.warn("Ticket passed is null and cannot be decoded");
            return null;
        }
        if (!(ticketToProcess instanceof EncodedTicket)) {
            LOGGER.debug("Ticket passed is not an encoded ticket: [{}], no decoding is necessary.", (Object)ticketToProcess.getClass().getSimpleName());
            return ticketToProcess;
        }
        EncodedTicket encodedTicket = (EncodedTicket)ticketToProcess;
        LOGGER.debug("Attempting to decode [{}]", (Object)ticketToProcess);
        Ticket ticket = (Ticket)SerializationUtils.decodeAndDeserializeObject((byte[])encodedTicket.getEncodedTicket(), (DecodableCipher)this.cipherExecutor, Ticket.class);
        LOGGER.debug("Decoded ticket to [{}]", (Object)ticket);
        return ticket;
    }

    protected Collection<Ticket> decodeTickets(Collection<Ticket> items) {
        return this.decodeTickets(items.stream()).collect(Collectors.toSet());
    }

    protected Stream<Ticket> decodeTickets(Stream<Ticket> items) {
        if (!this.isCipherExecutorEnabled()) {
            LOGGER.trace(TICKET_ENCRYPTION_LOG_MESSAGE);
            return items;
        }
        return items.map(this::decodeTicket);
    }

    protected boolean isCipherExecutorEnabled() {
        return this.cipherExecutor != null && this.cipherExecutor.isEnabled();
    }

    protected String serializeTicket(Ticket ticket) {
        return this.ticketSerializationManager.serializeTicket(ticket);
    }

    protected Ticket createEncodedTicket(Ticket ticket) throws Exception {
        LOGGER.debug("Encoding ticket [{}]", (Object)ticket);
        byte[] encodedTicketObject = SerializationUtils.serializeAndEncodeObject((EncodableCipher)this.cipherExecutor, (Serializable)ticket);
        return this.toEncodedTicket(ticket, encodedTicketObject);
    }

    protected Ticket toEncodedTicket(Ticket ticket, byte[] encodedTicketObject) throws Exception {
        String encodedTicketId = this.digestIdentifier(ticket.getId());
        return new DefaultEncodedTicket(encodedTicketId, ByteSource.wrap((byte[])encodedTicketObject).read(), ticket.getPrefix());
    }

    private void deleteLinkedProxyGrantingTickets(AtomicLong count, TicketGrantingTicket tgt) throws Exception {
        LinkedHashSet<String> pgts = new LinkedHashSet<String>(tgt.getProxyGrantingTickets().keySet());
        boolean hasPgts = !pgts.isEmpty();
        count.getAndAdd(this.deleteTickets(pgts));
        if (hasPgts) {
            LOGGER.debug("Removing proxy-granting tickets from parent ticket-granting ticket");
            tgt.getProxyGrantingTickets().clear();
            this.updateTicket((Ticket)tgt);
        }
    }

    private void deleteProxyGrantingTicketFromParent(ProxyGrantingTicket ticket) throws Exception {
        Ticket ticket2 = ticket.getTicketGrantingTicket();
        if (ticket2 instanceof TicketGrantingTicket) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket2;
            tgt.getProxyGrantingTickets().remove(ticket.getId());
            this.updateTicket((Ticket)tgt);
        }
    }

    private static long getTicketAgeSeconds(@NonNull Ticket ticket) {
        if (ticket == null) {
            throw new NullPointerException("ticket is marked non-null but is null");
        }
        return ZonedDateTime.now(ticket.getExpirationPolicy().getClock()).toEpochSecond() - ticket.getCreationTime().toEpochSecond();
    }

    protected Ticket deserializeTicket(String ticketContent, String type) {
        return this.ticketSerializationManager.deserializeTicket(ticketContent, type);
    }

    @Generated
    public AbstractTicketRegistry(CipherExecutor cipherExecutor, TicketSerializationManager ticketSerializationManager, TicketCatalog ticketCatalog, ApplicationContext applicationContext) {
        this.cipherExecutor = cipherExecutor;
        this.ticketSerializationManager = ticketSerializationManager;
        this.ticketCatalog = ticketCatalog;
        this.applicationContext = applicationContext;
    }

    @Generated
    public void setCipherExecutor(CipherExecutor cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    @Generated
    public CipherExecutor getCipherExecutor() {
        return this.cipherExecutor;
    }
}

