/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.ECParameterSpec;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.token.OidcRegisteredServiceJwtCipherExecutor;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.JsonUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jose4j.jwk.EcJwkGenerator;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.keys.AesKey;
import org.jose4j.keys.EllipticCurves;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public final class OidcJsonWebKeyStoreUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJsonWebKeyStoreUtils.class);
    private static final int JWK_EC_P384_SIZE = 384;
    private static final int JWK_EC_P512_SIZE = 512;

    public static Optional<JsonWebKeySet> getJsonWebKeySet(OidcRegisteredService oidcRegisteredService, ResourceLoader resourceLoader, Optional<OidcJsonWebKeyUsage> usage) {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            String serviceJwks = SpringExpressionLanguageValueResolver.getInstance().resolve(oidcRegisteredService.getJwks());
            LOGGER.trace("Loading JSON web key from [{}]", (Object)serviceJwks);
            Resource resource = OidcJsonWebKeyStoreUtils.getJsonWebKeySetResource(oidcRegisteredService, resourceLoader);
            if (resource == null) {
                LOGGER.debug("No JSON web keys or keystore resource could be found for [{}]", (Object)oidcRegisteredService.getServiceId());
                return Optional.empty();
            }
            Optional<String> requestedKid = Optional.ofNullable(oidcRegisteredService.getJwksKeyId());
            return OidcJsonWebKeyStoreUtils.buildJsonWebKeySet(resource, requestedKid, usage);
        }, throwable -> {
            LoggingUtils.error((Logger)LOGGER, (Throwable)throwable);
            return Optional.empty();
        }).get();
    }

    public static Optional<JsonWebKeySet> getJsonWebKeyFromJsonWebKeySet(JsonWebKeySet jwks, Optional<String> requestedKey, Optional<OidcJsonWebKeyUsage> usage) {
        if (jwks.getJsonWebKeys().isEmpty()) {
            LOGGER.warn("No JSON web keys are available in the keystore");
            return Optional.empty();
        }
        List keyResult = OidcJsonWebKeyStoreUtils.getJsonWebKeyByKeyId(jwks, requestedKey, usage).getJsonWebKeys().stream().filter(key -> key.getKey() != null).collect(Collectors.toList());
        if (keyResult.isEmpty()) {
            LOGGER.warn("Unable to locate JSON web key for [{}]", requestedKey.map(Object::toString));
            return Optional.empty();
        }
        return Optional.of(new JsonWebKeySet(keyResult));
    }

    private static List<JsonWebKey> filterJsonWebKeySetKeysBy(JsonWebKeySet jwks, Optional<String> keyIdRequest, Optional<OidcJsonWebKeyUsage> usage) {
        Predicate<JsonWebKey> filter = PublicJsonWebKey.class::isInstance;
        if (keyIdRequest.isPresent()) {
            filter = filter.and(jsonWebKey -> Strings.CI.equals(jsonWebKey.getKeyId(), (String)keyIdRequest.get()));
        }
        if (usage.isPresent()) {
            filter = filter.and(jsonWebKey -> ((OidcJsonWebKeyUsage)((Object)((Object)usage.get()))).is((JsonWebKey)jsonWebKey));
        }
        return jwks.getJsonWebKeys().stream().filter(filter).map(PublicJsonWebKey.class::cast).collect(Collectors.toList());
    }

    private static JsonWebKeySet getJsonWebKeyByKeyId(JsonWebKeySet jwks, Optional<String> kid, Optional<OidcJsonWebKeyUsage> usage) {
        if (kid.isPresent()) {
            List<JsonWebKey> resultJwks = OidcJsonWebKeyStoreUtils.filterJsonWebKeySetKeysBy(jwks, kid, usage);
            if (usage.isPresent() && resultJwks.isEmpty()) {
                LOGGER.debug("No JSON web keys found for [{}] and usage [{}]. Skipping usage...", (Object)kid.get(), (Object)usage.get());
                resultJwks = OidcJsonWebKeyStoreUtils.filterJsonWebKeySetKeysBy(jwks, kid, Optional.empty());
            }
            LOGGER.debug("JSON web keys found for [{}] are [{}]", (Object)kid.get(), resultJwks);
            return new JsonWebKeySet(resultJwks);
        }
        List<JsonWebKey> resultJwks = OidcJsonWebKeyStoreUtils.filterJsonWebKeySetKeysBy(jwks, Optional.empty(), usage);
        if (usage.isPresent() && resultJwks.isEmpty()) {
            LOGGER.debug("No JSON web keys found for usage [{}]. Skipping usage...", (Object)usage.get());
            resultJwks = OidcJsonWebKeyStoreUtils.filterJsonWebKeySetKeysBy(jwks, Optional.empty(), Optional.empty());
        }
        LOGGER.debug("JSON web keys found are [{}]", resultJwks);
        return new JsonWebKeySet(resultJwks);
    }

    private static Optional<JsonWebKeySet> buildJsonWebKeySet(Resource resource, Optional<String> keyId, Optional<OidcJsonWebKeyUsage> usage) throws Exception {
        LOGGER.debug("Loading JSON web key from [{}]", (Object)resource);
        try (InputStream is = resource.getInputStream();){
            String json = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("Retrieved JSON web key from [{}] as [{}]", (Object)resource, (Object)json);
            Optional<JsonWebKeySet> optional = OidcJsonWebKeyStoreUtils.buildJsonWebKeySet(json, keyId, usage);
            return optional;
        }
    }

    private static Optional<JsonWebKeySet> buildJsonWebKeySet(String json, Optional<String> keyId, Optional<OidcJsonWebKeyUsage> usage) throws Exception {
        if (JsonUtils.isValidJson((String)json)) {
            return OidcJsonWebKeyStoreUtils.getJsonWebKeyFromJsonWebKeySet(new JsonWebKeySet(json), keyId, usage);
        }
        AesKey key = new AesKey(json.getBytes(StandardCharsets.UTF_8));
        OctetSequenceJsonWebKey jsonWebKey = new OctetSequenceJsonWebKey((Key)key);
        jsonWebKey.setKeyId(keyId.orElse(""));
        jsonWebKey.setUse(usage.map(Enum::name).orElse(""));
        return Optional.of(new JsonWebKeySet(new JsonWebKey[]{jsonWebKey}));
    }

    private static Resource getJsonWebKeySetResource(OidcRegisteredService service, ResourceLoader resourceLoader) {
        String serviceJwks = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getJwks());
        if (StringUtils.isNotBlank((CharSequence)serviceJwks)) {
            if (ResourceUtils.doesResourceExist((String)serviceJwks)) {
                return resourceLoader.getResource(serviceJwks);
            }
            return new InputStreamResource((InputStream)new ByteArrayInputStream(serviceJwks.getBytes(StandardCharsets.UTF_8)), "JWKS");
        }
        return null;
    }

    public static JsonWebKeySet parseJsonWebKeySet(String json) {
        return (JsonWebKeySet)FunctionUtils.doUnchecked(() -> new JsonWebKeySet(json));
    }

    private static PublicJsonWebKey generateJsonWebKeyEC(ECParameterSpec spec) {
        return (PublicJsonWebKey)FunctionUtils.doUnchecked(() -> EcJwkGenerator.generateJwk((ECParameterSpec)spec));
    }

    public static PublicJsonWebKey generateJsonWebKey(String jwksType, int jwksKeySize, OidcJsonWebKeyUsage usage) {
        switch (jwksType.trim().toLowerCase(Locale.ENGLISH)) {
            case "ec": {
                if (jwksKeySize == 384) {
                    PublicJsonWebKey jwk = OidcJsonWebKeyStoreUtils.generateJsonWebKeyEC(EllipticCurves.P384);
                    jwk.setKeyId(UUID.randomUUID().toString());
                    jwk.setAlgorithm("ES384");
                    usage.assignTo((JsonWebKey)jwk);
                    return jwk;
                }
                if (jwksKeySize == 512) {
                    PublicJsonWebKey jwk = OidcJsonWebKeyStoreUtils.generateJsonWebKeyEC(EllipticCurves.P521);
                    jwk.setKeyId(UUID.randomUUID().toString());
                    jwk.setAlgorithm("ES512");
                    usage.assignTo((JsonWebKey)jwk);
                    return jwk;
                }
                PublicJsonWebKey jwk = OidcJsonWebKeyStoreUtils.generateJsonWebKeyEC(EllipticCurves.P256);
                jwk.setKeyId(UUID.randomUUID().toString());
                jwk.setAlgorithm("ES512");
                usage.assignTo((JsonWebKey)jwk);
                return jwk;
            }
        }
        RsaJsonWebKey newJwk = (RsaJsonWebKey)FunctionUtils.doUnchecked(() -> RsaJwkGenerator.generateJwk((int)jwksKeySize));
        newJwk.setKeyId(UUID.randomUUID().toString());
        usage.assignTo((JsonWebKey)newJwk);
        return newJwk;
    }

    public static Optional<JsonWebKeySet> fetchJsonWebKeySetForSigning(RegisteredService registeredService, OidcRegisteredServiceJwtCipherExecutor cipherExecutor, boolean fallbackToDefault) {
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        String issuer = cipherExecutor.getOidcIssuerService().determineIssuer(Optional.of(oidcRegisteredService));
        LOGGER.trace("Using issuer [{}] to determine JWKS from default keystore cache", (Object)issuer);
        Optional serviceJsonWebKeys = Objects.requireNonNull((Optional)cipherExecutor.getRegisteredServiceJsonWebKeystoreCache().get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)oidcRegisteredService, OidcJsonWebKeyUsage.SIGNING)));
        if (serviceJsonWebKeys.isPresent()) {
            JsonWebKeySet jsonWebKey = (JsonWebKeySet)serviceJsonWebKeys.get();
            LOGGER.debug("Found JSON web key to sign the token: [{}]", (Object)jsonWebKey);
            List keys = jsonWebKey.getJsonWebKeys().stream().filter(key -> key.getKey() != null).collect(Collectors.toList());
            return Optional.of(new JsonWebKeySet(keys));
        }
        if (fallbackToDefault) {
            OidcJsonWebKeyCacheKey cacheKey = new OidcJsonWebKeyCacheKey(issuer, OidcJsonWebKeyUsage.SIGNING);
            JsonWebKeySet defaultJsonWebKeys = (JsonWebKeySet)cipherExecutor.getDefaultJsonWebKeystoreCache().get((Object)cacheKey);
            if (defaultJsonWebKeys != null) {
                return Optional.of(defaultJsonWebKeys);
            }
        }
        LOGGER.warn("No [{}] key could be found for issuer [{}]", (Object)OidcJsonWebKeyUsage.SIGNING, (Object)issuer);
        return Optional.empty();
    }

    public static Optional<JsonWebKeySet> fetchJsonWebKeySetForEncryption(RegisteredService registeredService, OidcRegisteredServiceJwtCipherExecutor cipherExecutor) {
        OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)registeredService;
        Optional jwks = Objects.requireNonNull((Optional)cipherExecutor.getRegisteredServiceJsonWebKeystoreCache().get((Object)new OidcJsonWebKeyCacheKey((OAuthRegisteredService)oidcRegisteredService, OidcJsonWebKeyUsage.ENCRYPTION)));
        if (jwks.isEmpty()) {
            LOGGER.warn("Service [{}] with client id [{}] is configured to encrypt tokens, yet no JSON web key is available", (Object)oidcRegisteredService.getServiceId(), (Object)oidcRegisteredService.getClientId());
            return Optional.empty();
        }
        JsonWebKeySet jsonWebKey = (JsonWebKeySet)jwks.get();
        LOGGER.debug("Found JSON web key to encrypt the token: [{}]", (Object)jsonWebKey);
        List<JsonWebKey> keys = jsonWebKey.getJsonWebKeys().stream().filter(key -> key.getKey() != null).toList();
        if (keys.isEmpty()) {
            LOGGER.warn("No valid JSON web keys used for encryption can be found");
            return Optional.empty();
        }
        return Optional.of(new JsonWebKeySet(keys));
    }

    @Generated
    private OidcJsonWebKeyStoreUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

