/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OidcPushedAuthorizationRequestUriResponseBuilder
extends BaseOAuth20AuthorizationResponseBuilder<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcPushedAuthorizationRequestUriResponseBuilder.class);

    public OidcPushedAuthorizationRequestUriResponseBuilder(OidcConfigurationContext configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super((OAuth20ConfigurationContext)configurationContext, authorizationModelAndViewBuilder);
    }

    @Audit(action="OAUTH2_AUTHORIZATION_RESPONSE", actionResolverName="OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_AUTHORIZATION_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView build(AccessTokenRequestContext holder) throws Throwable {
        OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)((OidcConfigurationContext)this.configurationContext).getTicketFactory().get(OidcPushedAuthorizationRequest.class);
        OidcPushedAuthorizationRequest uri = factory.create(holder);
        LOGGER.debug("Generated pushed authorization URI code: [{}]", (Object)uri);
        ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().addTicket((Ticket)uri);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("expires_in", String.valueOf(uri.getExpirationPolicy().getTimeToLive()));
        parameters.put("request_uri", uri.getId());
        LOGGER.debug("Pushed authorization request verification successful for client [{}] with redirect uri [{}]", (Object)holder.getClientId(), (Object)holder.getRedirectUri());
        return this.authorizationModelAndViewBuilder.build(holder.getRegisteredService(), holder.getResponseMode(), holder.getRedirectUri(), parameters);
    }

    public Optional<OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder> toAuthorizationRequest(WebContext context, Authentication authentication, Service service, OAuthRegisteredService registeredService) {
        Optional requestUri = context.getRequestParameter("request_uri");
        if (context.getRequestURL().endsWith("oidcAuthorize") && requestUri.isEmpty()) {
            return Optional.empty();
        }
        OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder authzRequestBuilder = (OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder)super.toAuthorizationRequest(context, authentication, service, registeredService).orElseThrow();
        return requestUri.map(Unchecked.function(uri -> {
            OidcPushedAuthorizationRequestFactory factory = (OidcPushedAuthorizationRequestFactory)((OidcConfigurationContext)this.configurationContext).getTicketFactory().get(OidcPushedAuthorizationRequest.class);
            OidcPushedAuthorizationRequest pushAuthzTicket = (OidcPushedAuthorizationRequest)((OidcConfigurationContext)this.configurationContext).getTicketRegistry().getTicket(uri, OidcPushedAuthorizationRequest.class);
            FunctionUtils.doIf((boolean)pushAuthzTicket.isExpired(), (Consumer)Unchecked.consumer(r -> ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().deleteTicket((Ticket)pushAuthzTicket)), (Consumer)Unchecked.consumer(r -> ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().updateTicket((Ticket)pushAuthzTicket))).accept(pushAuthzTicket);
            TicketGrantingTicket tgt = ((OidcConfigurationContext)this.configurationContext).fetchTicketGrantingTicketFrom((JEEContext)context);
            Authentication pushAuthzAuthentication = DefaultAuthenticationBuilder.newInstance((Authentication)tgt.getAuthentication()).mergeAttributes(pushAuthzTicket.getAuthentication().getAttributes()).build();
            AccessTokenRequestContext tokenRequest = factory.toAccessTokenRequest(pushAuthzTicket).withTicketGrantingTicket((Ticket)tgt).withAuthentication(pushAuthzAuthentication);
            pushAuthzTicket.update();
            ((OidcConfigurationContext)this.configurationContext).getTicketRegistry().updateTicket((Ticket)pushAuthzTicket);
            OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder value = authzRequestBuilder.accessTokenRequest(tokenRequest).responseType(tokenRequest.getResponseType().getType()).clientId(tokenRequest.getClientId()).grantType(tokenRequest.getGrantType().getType());
            return Optional.of(value);
        })).orElseGet(() -> Optional.of(authzRequestBuilder.singleSignOnSessionRequired(!context.getRequestURL().endsWith("oidcPushAuthorize"))));
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return context.getUrl().endsWith("oidcPushAuthorize") && StringUtils.isNotBlank((CharSequence)context.getClientId());
    }

    public int getOrder() {
        return 0;
    }
}

