/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler.support;

import java.net.URL;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.credential.HttpBasedServiceCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAuthenticationHandler
extends AbstractAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyAuthenticationHandler.class);
    private final HttpClient httpClient;

    public ProxyAuthenticationHandler(String name, PrincipalFactory principalFactory, Integer order, HttpClient httpClient) {
        super(name, principalFactory, order);
        this.httpClient = httpClient;
    }

    public AuthenticationHandlerExecutionResult authenticate(Credential credential, Service service) throws Throwable {
        HttpBasedServiceCredential httpCredential = (HttpBasedServiceCredential)credential;
        if (!httpCredential.getService().getProxyPolicy().isAllowedProxyCallbackUrl((RegisteredService)httpCredential.getService(), httpCredential.getCallbackUrl())) {
            LOGGER.warn("Proxy policy for service [{}] cannot authorize the requested callback url [{}].", (Object)httpCredential.getService(), (Object)httpCredential.getCallbackUrl());
            throw new FailedLoginException(String.valueOf(httpCredential.getCallbackUrl()) + " cannot be authorized");
        }
        LOGGER.debug("Attempting to authenticate [{}]", (Object)httpCredential);
        URL callbackUrl = httpCredential.getCallbackUrl();
        if (!this.httpClient.isValidEndPoint(callbackUrl)) {
            throw new FailedLoginException(callbackUrl.toExternalForm() + " sent an unacceptable response status code");
        }
        String principalId = httpCredential.getCredentialMetadata().getId();
        Principal proxyPrincipal = this.principalFactory.createPrincipal(principalId);
        return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (Credential)httpCredential, proxyPrincipal);
    }

    public boolean supports(Credential credential) {
        return credential instanceof HttpBasedServiceCredential;
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return HttpBasedServiceCredential.class.isAssignableFrom(clazz);
    }
}

