/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import lombok.Generated;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenAuthorizationCodeGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class AccessTokenRefreshTokenGrantRequestExtractor
extends AccessTokenAuthorizationCodeGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenRefreshTokenGrantRequestExtractor.class);

    public AccessTokenRefreshTokenGrantRequestExtractor(ObjectProvider<OAuth20ConfigurationContext> oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @Override
    public boolean supports(WebContext context) {
        String grantType = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    @Override
    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.REFRESH_TOKEN;
    }

    @Override
    protected String getOAuthParameterName() {
        return "refresh_token";
    }

    @Override
    protected AccessTokenRequestContext extractInternal(WebContext context, AccessTokenRequestContext accessTokenRequestContext) {
        OAuthRegisteredService registeredService = this.getOAuthRegisteredServiceBy(context);
        if (registeredService == null) {
            throw UnauthorizedServiceException.denied((String)"Unable to locate service in registry");
        }
        boolean shouldRenewRefreshToken = registeredService.isGenerateRefreshToken() && registeredService.isRenewRefreshToken();
        return super.extractInternal(context, accessTokenRequestContext.withGenerateRefreshToken(shouldRenewRefreshToken).withExpireOldRefreshToken(shouldRenewRefreshToken));
    }

    @Override
    protected OAuthRegisteredService getOAuthRegisteredServiceBy(WebContext context) {
        String clientId = this.getRegisteredServiceIdentifierFromRequest(context);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getServicesManager(), clientId);
        LOGGER.debug("Located registered service [{}]", (Object)registeredService);
        return registeredService;
    }

    @Override
    protected String getRegisteredServiceIdentifierFromRequest(WebContext context) {
        CallContext callContext = new CallContext(context, ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getSessionStore());
        return (String)((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getLeft();
    }
}

