/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConsumerProtocolTest {
    private final TopicPartition tp1 = new TopicPartition("foo", 1);
    private final TopicPartition tp2 = new TopicPartition("bar", 2);
    private final Optional<String> groupInstanceId = Optional.of("instance.id");
    private final int generationId = 1;
    private final Optional<String> rackId = Optional.of("rack-a");

    @Test
    public void serializeDeserializeSubscriptionAllVersions() {
        List<TopicPartition> ownedPartitions = Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap("hello".getBytes()), ownedPartitions, 1, this.rackId);
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)version);
            ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
            Assertions.assertEquals(TestUtils.toSet(subscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
            Assertions.assertEquals((Object)subscription.userData(), (Object)parsedSubscription.userData());
            Assertions.assertFalse((boolean)parsedSubscription.groupInstanceId().isPresent());
            if (version >= 1) {
                Assertions.assertEquals(TestUtils.toSet(subscription.ownedPartitions()), TestUtils.toSet(parsedSubscription.ownedPartitions()));
            } else {
                Assertions.assertEquals(Collections.emptyList(), (Object)parsedSubscription.ownedPartitions());
            }
            if (version >= 2) {
                Assertions.assertEquals((int)1, (Integer)parsedSubscription.generationId().orElse(-1));
            } else {
                Assertions.assertFalse((boolean)parsedSubscription.generationId().isPresent());
            }
            if (version >= 3) {
                Assertions.assertEquals(this.rackId, (Object)parsedSubscription.rackId());
                continue;
            }
            Assertions.assertEquals(Optional.empty(), (Object)parsedSubscription.rackId());
        }
    }

    @Test
    public void serializeDeserializeMetadata() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap(new byte[0]));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assertions.assertEquals(TestUtils.toSet(subscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
        Assertions.assertEquals((int)0, (int)parsedSubscription.userData().limit());
        Assertions.assertFalse((boolean)parsedSubscription.groupInstanceId().isPresent());
        Assertions.assertFalse((boolean)parsedSubscription.generationId().isPresent());
        Assertions.assertFalse((boolean)parsedSubscription.rackId().isPresent());
    }

    @Test
    public void serializeDeserializeMetadataAndGroupInstanceId() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap(new byte[0]));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        parsedSubscription.setGroupInstanceId(this.groupInstanceId);
        Assertions.assertEquals(TestUtils.toSet(subscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
        Assertions.assertEquals((int)0, (int)parsedSubscription.userData().limit());
        Assertions.assertEquals(this.groupInstanceId, (Object)parsedSubscription.groupInstanceId());
        Assertions.assertFalse((boolean)parsedSubscription.generationId().isPresent());
        Assertions.assertFalse((boolean)parsedSubscription.rackId().isPresent());
    }

    @Test
    public void serializeDeserializeNullSubscriptionUserData() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null);
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assertions.assertEquals(TestUtils.toSet(subscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
        Assertions.assertNull((Object)parsedSubscription.userData());
        Assertions.assertFalse((boolean)parsedSubscription.rackId().isPresent());
    }

    @Test
    public void serializeSubscriptionShouldOrderTopics() {
        Assertions.assertEquals((Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null, Arrays.asList(this.tp1, this.tp2))), (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Arrays.asList("bar", "foo"), null, Arrays.asList(this.tp1, this.tp2))));
    }

    @Test
    public void serializeSubscriptionShouldOrderOwnedPartitions() {
        Assertions.assertEquals((Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null, Arrays.asList(this.tp1, this.tp2))), (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null, Arrays.asList(this.tp2, this.tp1))));
    }

    @Test
    public void deserializeOldSubscriptionVersion() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null);
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)0);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assertions.assertEquals(TestUtils.toSet(parsedSubscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
        Assertions.assertNull((Object)parsedSubscription.userData());
        Assertions.assertTrue((boolean)parsedSubscription.ownedPartitions().isEmpty());
        Assertions.assertFalse((boolean)parsedSubscription.generationId().isPresent());
        Assertions.assertFalse((boolean)parsedSubscription.rackId().isPresent());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void deserializeNewSubscriptionWithOldVersion(boolean hasGenerationIdAndRack) {
        ConsumerPartitionAssignor.Subscription subscription = hasGenerationIdAndRack ? new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null, Collections.singletonList(this.tp2), 1, this.rackId) : new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null, Collections.singletonList(this.tp2));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerProtocol.deserializeVersion((ByteBuffer)buffer);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer, (short)0);
        Assertions.assertEquals(TestUtils.toSet(subscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
        Assertions.assertNull((Object)parsedSubscription.userData());
        Assertions.assertTrue((boolean)parsedSubscription.ownedPartitions().isEmpty());
        Assertions.assertFalse((boolean)parsedSubscription.groupInstanceId().isPresent());
        Assertions.assertFalse((boolean)parsedSubscription.generationId().isPresent());
        Assertions.assertFalse((boolean)parsedSubscription.rackId().isPresent());
    }

    @Test
    public void deserializeFutureSubscriptionVersion() {
        ByteBuffer buffer = this.generateFutureSubscriptionVersionData();
        ConsumerPartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        subscription.setGroupInstanceId(this.groupInstanceId);
        Assertions.assertEquals(Collections.singleton("topic"), TestUtils.toSet(subscription.topics()));
        Assertions.assertEquals(Collections.singleton(this.tp2), TestUtils.toSet(subscription.ownedPartitions()));
        Assertions.assertEquals(this.groupInstanceId, (Object)subscription.groupInstanceId());
        Assertions.assertEquals((int)1, (Integer)subscription.generationId().orElse(-1));
        Assertions.assertEquals(this.rackId, (Object)subscription.rackId());
    }

    @Test
    public void serializeDeserializeAssignmentAllVersions() {
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        ConsumerPartitionAssignor.Assignment assignment = new ConsumerPartitionAssignor.Assignment(partitions, ByteBuffer.wrap("hello".getBytes()));
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)assignment, (short)version);
            ConsumerPartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
            Assertions.assertEquals(TestUtils.toSet(partitions), TestUtils.toSet(parsedAssignment.partitions()));
            Assertions.assertEquals((Object)assignment.userData(), (Object)parsedAssignment.userData());
        }
    }

    @Test
    public void serializeDeserializeConsumerProtocolAssignmentAllVersions() {
        ConsumerProtocolAssignment assignment = new ConsumerProtocolAssignment().setAssignedPartitions(new ConsumerProtocolAssignment.TopicPartitionCollection(Arrays.asList(new ConsumerProtocolAssignment.TopicPartition().setTopic(this.tp1.topic()).setPartitions(Collections.singletonList(this.tp1.partition())), new ConsumerProtocolAssignment.TopicPartition().setTopic(this.tp2.topic()).setPartitions(Collections.singletonList(this.tp2.partition()))).iterator())).setUserData(ByteBuffer.wrap("hello".getBytes()));
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerProtocolAssignment)assignment, (short)version);
            ConsumerProtocolAssignment parsedAssignment = ConsumerProtocol.deserializeConsumerProtocolAssignment((ByteBuffer)buffer);
            Assertions.assertEquals(TestUtils.toSet(assignment.assignedPartitions()), TestUtils.toSet(parsedAssignment.assignedPartitions()));
            Assertions.assertEquals((Object)assignment.userData(), (Object)parsedAssignment.userData());
        }
    }

    @Test
    public void serializeDeserializeAssignment() {
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(partitions, ByteBuffer.wrap(new byte[0])));
        ConsumerPartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assertions.assertEquals(TestUtils.toSet(partitions), TestUtils.toSet(parsedAssignment.partitions()));
        Assertions.assertEquals((int)0, (int)parsedAssignment.userData().limit());
    }

    @Test
    public void deserializeNullAssignmentUserData() {
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(partitions, null));
        ConsumerPartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assertions.assertEquals(TestUtils.toSet(partitions), TestUtils.toSet(parsedAssignment.partitions()));
        Assertions.assertNull((Object)parsedAssignment.userData());
    }

    @Test
    public void deserializeFutureAssignmentVersion() {
        short version = 100;
        Schema assignmentSchemaV100 = new Schema(new Field[]{new Field("assigned_partitions", (Type)new ArrayOf((Type)ConsumerProtocolAssignment.TopicPartition.SCHEMA_0)), new Field("user_data", (Type)Type.BYTES), new Field("foo", (Type)Type.STRING)});
        Struct assignmentV100 = new Struct(assignmentSchemaV100);
        assignmentV100.set("assigned_partitions", (Object)new Object[]{new Struct(ConsumerProtocolAssignment.TopicPartition.SCHEMA_0).set("topic", (Object)this.tp1.topic()).set("partitions", (Object)new Object[]{this.tp1.partition()})});
        assignmentV100.set("user_data", (Object)ByteBuffer.wrap(new byte[0]));
        assignmentV100.set("foo", (Object)"bar");
        Struct headerV100 = new Struct(new Schema(new Field[]{new Field("version", (Type)Type.INT16)}));
        headerV100.set("version", (Object)version);
        ByteBuffer buffer = ByteBuffer.allocate(assignmentV100.sizeOf() + headerV100.sizeOf());
        headerV100.writeTo(buffer);
        assignmentV100.writeTo(buffer);
        buffer.flip();
        ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assertions.assertEquals(TestUtils.toSet(Collections.singletonList(this.tp1)), TestUtils.toSet(assignment.partitions()));
    }

    @Test
    public void serializeDeserializeConsumerProtocolSubscriptionAllVersions() {
        List<TopicPartition> ownedPartitions = Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap("hello".getBytes()), ownedPartitions, 1, this.rackId);
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)version);
            ConsumerProtocolSubscription parsedSubscription = ConsumerProtocol.deserializeConsumerProtocolSubscription((ByteBuffer)buffer);
            Assertions.assertEquals(TestUtils.toSet(subscription.topics()), TestUtils.toSet(parsedSubscription.topics()));
            Assertions.assertEquals((Object)subscription.userData(), (Object)parsedSubscription.userData());
            if (version >= 1) {
                Assertions.assertEquals(TestUtils.toSet(Arrays.asList(new ConsumerProtocolSubscription.TopicPartition().setTopic("foo").setPartitions(Collections.singletonList(0)), new ConsumerProtocolSubscription.TopicPartition().setTopic("bar").setPartitions(Collections.singletonList(0)))), TestUtils.toSet(parsedSubscription.ownedPartitions()));
            } else {
                Assertions.assertEquals((Object)new ConsumerProtocolSubscription.TopicPartitionCollection(), (Object)parsedSubscription.ownedPartitions());
            }
            if (version >= 2) {
                Assertions.assertEquals((int)1, (int)parsedSubscription.generationId());
            } else {
                Assertions.assertEquals((int)-1, (int)parsedSubscription.generationId());
            }
            if (version >= 3) {
                Assertions.assertEquals((Object)this.rackId.get(), (Object)parsedSubscription.rackId());
                continue;
            }
            Assertions.assertNull((Object)parsedSubscription.rackId());
        }
    }

    private ByteBuffer generateFutureSubscriptionVersionData() {
        short version = 100;
        Schema subscriptionSchemaV100 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)Type.STRING)), new Field("user_data", (Type)Type.NULLABLE_BYTES), new Field("owned_partitions", (Type)new ArrayOf((Type)ConsumerProtocolSubscription.TopicPartition.SCHEMA_1)), new Field("generation_id", (Type)Type.INT32), new Field("rack_id", (Type)Type.STRING), new Field("bar", (Type)Type.STRING)});
        Struct subscriptionV100 = new Struct(subscriptionSchemaV100);
        subscriptionV100.set("topics", (Object)new Object[]{"topic"});
        subscriptionV100.set("user_data", (Object)ByteBuffer.wrap(new byte[0]));
        subscriptionV100.set("owned_partitions", (Object)new Object[]{new Struct(ConsumerProtocolSubscription.TopicPartition.SCHEMA_1).set("topic", (Object)this.tp2.topic()).set("partitions", (Object)new Object[]{this.tp2.partition()})});
        subscriptionV100.set("generation_id", (Object)1);
        subscriptionV100.set("rack_id", this.rackId.orElse(null));
        subscriptionV100.set("bar", (Object)"bar");
        Struct headerV100 = new Struct(new Schema(new Field[]{new Field("version", (Type)Type.INT16)}));
        headerV100.set("version", (Object)version);
        ByteBuffer buffer = ByteBuffer.allocate(subscriptionV100.sizeOf() + headerV100.sizeOf());
        headerV100.writeTo(buffer);
        subscriptionV100.writeTo(buffer);
        buffer.flip();
        return buffer;
    }
}

