/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util;

import java.net.InetAddress;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.util.AbstractSamlObjectBuilder;
import org.apereo.cas.support.saml.util.Saml20ObjectBuilder;
import org.apereo.cas.util.CompressionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.ecp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaml20ObjectBuilder
extends AbstractSamlObjectBuilder
implements Saml20ObjectBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSaml20ObjectBuilder.class);

    protected AbstractSaml20ObjectBuilder(OpenSamlConfigBean configBean) {
        super(configBean);
    }

    private static void configureAttributeNameFormat(Attribute attribute, String nameFormat) {
        String compareFormat;
        LOGGER.trace("Configuring Attribute's: [{}] nameFormat: [{}]", (Object)attribute, (Object)nameFormat);
        if (StringUtils.isBlank((CharSequence)nameFormat)) {
            return;
        }
        switch (compareFormat = nameFormat.trim().toLowerCase(Locale.ENGLISH)) {
            case "basic": 
            case "urn:oasis:names:tc:SAML:2.0:attrname-format:basic": {
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
                break;
            }
            case "uri": 
            case "urn:oasis:names:tc:SAML:2.0:attrname-format:uri": {
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
                break;
            }
            case "unspecified": 
            case "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified": {
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
                break;
            }
            default: {
                attribute.setNameFormat(nameFormat);
            }
        }
    }

    @Override
    public NameID newNameID(String nameIdFormat, String nameIdValue) {
        NameID nameId = this.newSamlObject(NameID.class);
        nameId.setFormat(nameIdFormat);
        nameId.setValue(nameIdValue);
        return nameId;
    }

    public Response newEcpResponse(String assertionConsumerUrl) {
        Response samlResponse = this.newSamlObject(Response.class);
        samlResponse.setSOAP11MustUnderstand(Boolean.TRUE);
        samlResponse.setSOAP11Actor("http://schemas.xmlsoap.org/soap/actor/next");
        samlResponse.setAssertionConsumerServiceURL(assertionConsumerUrl);
        return samlResponse;
    }

    public org.opensaml.saml.saml2.core.Response newResponse(String id, ZonedDateTime issueInstant, String recipient, WebApplicationService service) {
        LOGGER.trace("Creating Response instance for id: [{}], issueInstant: [{}]], recipient: [{}], service: [{}]", new Object[]{id, issueInstant, recipient, service});
        org.opensaml.saml.saml2.core.Response samlResponse = this.newSamlObject(org.opensaml.saml.saml2.core.Response.class);
        samlResponse.setID(id);
        samlResponse.setIssueInstant(issueInstant.toInstant());
        samlResponse.setVersion(SAMLVersion.VERSION_20);
        if (StringUtils.isNotBlank((CharSequence)recipient)) {
            LOGGER.debug("Setting provided RequestId [{}] as InResponseTo", (Object)recipient);
            samlResponse.setInResponseTo(recipient);
        } else {
            LOGGER.debug("No recipient is provided. Skipping InResponseTo");
        }
        return samlResponse;
    }

    @Override
    public Status newStatus(String codeValue, String statusMessage) {
        LOGGER.trace("Creating new SAML Status for code value: [{}], status message: [{}]", (Object)codeValue, (Object)statusMessage);
        Status status = this.newSamlObject(Status.class);
        StatusCode statusCode = this.newSamlObject(StatusCode.class);
        statusCode.setValue(codeValue);
        status.setStatusCode(statusCode);
        if (StringUtils.isNotBlank((CharSequence)statusMessage)) {
            StatusMessage message = this.newSamlObject(StatusMessage.class);
            message.setValue(statusMessage);
            status.setStatusMessage(message);
        }
        return status;
    }

    public Assertion newAssertion(List<Statement> authnStatement, String issuer, ZonedDateTime issuedAt, String id) {
        LOGGER.trace("Creating new SAML Assertion with id: [{}], for issuer: [{}], issued at: [{}]", new Object[]{id, issuer, issuedAt});
        Assertion assertion = this.newSamlObject(Assertion.class);
        assertion.setID(id);
        assertion.setIssueInstant(issuedAt.toInstant());
        assertion.setIssuer(this.newIssuer(issuer));
        assertion.getStatements().addAll(authnStatement);
        return assertion;
    }

    @Override
    public LogoutResponse newLogoutResponse(String id, String destination, Issuer issuer, Status status, String recipient) {
        LogoutResponse logoutResponse = this.newSamlObject(LogoutResponse.class);
        logoutResponse.setIssuer(issuer);
        logoutResponse.setIssueInstant(Instant.now(Clock.systemUTC()));
        logoutResponse.setID(id);
        logoutResponse.setDestination(destination);
        logoutResponse.setInResponseTo(recipient);
        logoutResponse.setStatus(status);
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        return logoutResponse;
    }

    @Override
    public LogoutRequest newLogoutRequest(String id, ZonedDateTime issueInstant, String destination, Issuer issuer, String sessionIndex, NameID nameId) {
        LOGGER.trace("Creating new SAML LogoutRequest with id: [{}], for issuer: [{}], for destination: [{}], for NameID: [{}],issued at: [{}]", new Object[]{id, issuer, destination, nameId, issueInstant});
        LogoutRequest request = this.newSamlObject(LogoutRequest.class);
        request.setID(id);
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(issueInstant.toInstant());
        request.setIssuer(issuer);
        request.setDestination(destination);
        if (StringUtils.isNotBlank((CharSequence)sessionIndex)) {
            SessionIndex sessionIdx = this.newSamlObject(SessionIndex.class);
            sessionIdx.setValue(sessionIndex);
            request.getSessionIndexes().add(sessionIdx);
        }
        if (nameId != null) {
            request.setNameID(nameId);
        }
        return request;
    }

    @Override
    public Issuer newIssuer(String issuerValue) {
        Issuer issuer = this.newSamlObject(Issuer.class);
        issuer.setValue(issuerValue);
        return issuer;
    }

    public void addAttributeValuesToSaml2Attribute(String attributeName, Object attributeValue, String valueType, List<XMLObject> attributeList) {
        this.addAttributeValuesToSamlAttribute(attributeName, attributeValue, valueType, attributeList, AttributeValue.DEFAULT_ELEMENT_NAME);
    }

    public AuthnStatement newAuthnStatement(AuthnContext context, ZonedDateTime authnInstant, String sessionIndex) {
        LOGGER.trace("Building authentication statement with context class ref [{}] @ [{}] with index [{}]", new Object[]{context, authnInstant, sessionIndex});
        AuthnStatement stmt = this.newSamlObject(AuthnStatement.class);
        stmt.setAuthnContext(context);
        stmt.setAuthnInstant(authnInstant.toInstant());
        stmt.setSessionIndex(sessionIndex);
        return stmt;
    }

    public Conditions newConditions(ZonedDateTime notBefore, ZonedDateTime notOnOrAfter, String ... audienceUri) {
        LOGGER.debug("Building conditions for audience [{}] that enforce not-before [{}] and not-after [{}]", new Object[]{audienceUri, notBefore, notOnOrAfter});
        Conditions conditions = this.newSamlObject(Conditions.class);
        conditions.setNotBefore(notBefore.toInstant());
        conditions.setNotOnOrAfter(notOnOrAfter.toInstant());
        AudienceRestriction audienceRestriction = this.newSamlObject(AudienceRestriction.class);
        Arrays.stream(audienceUri).forEach(audienceEntry -> {
            Audience audience = this.newSamlObject(Audience.class);
            audience.setURI(audienceEntry);
            audienceRestriction.getAudiences().add(audience);
        });
        conditions.getAudienceRestrictions().add(audienceRestriction);
        return conditions;
    }

    public SubjectConfirmation newSubjectConfirmation(String recipient, ZonedDateTime notOnOrAfter, String inResponseTo, ZonedDateTime notBefore, InetAddress address) {
        LOGGER.debug("Building subject confirmation for recipient [{}], in response to [{}]", (Object)recipient, (Object)inResponseTo);
        SubjectConfirmation confirmation = this.newSamlObject(SubjectConfirmation.class);
        confirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData data = this.newSamlObject(SubjectConfirmationData.class);
        FunctionUtils.doIfNotBlank((CharSequence)recipient, arg_0 -> ((SubjectConfirmationData)data).setRecipient(arg_0));
        FunctionUtils.doIfNotBlank((CharSequence)inResponseTo, arg_0 -> ((SubjectConfirmationData)data).setInResponseTo(arg_0));
        FunctionUtils.doIfNotNull((Object)address, __ -> data.setAddress(address.getHostAddress()));
        FunctionUtils.doIfNotNull((Object)notOnOrAfter, __ -> data.setNotOnOrAfter(notOnOrAfter.toInstant()));
        FunctionUtils.doIfNotNull((Object)notBefore, __ -> data.setNotBefore(notBefore.toInstant()));
        confirmation.setSubjectConfirmationData(data);
        return confirmation;
    }

    public Subject newSubject(SAMLObject nameId, SAMLObject subjectConfNameId, SubjectConfirmation subjectConfirmation) {
        NameID instance;
        LOGGER.debug("Building subject for NameID [{}]", (Object)nameId);
        Subject subject = this.newSamlObject(Subject.class);
        subject.setNameID(null);
        subject.getSubjectConfirmations().forEach(confirmation -> confirmation.setNameID(null));
        if (nameId instanceof NameID) {
            instance = (NameID)nameId;
            subject.setNameID(instance);
            subject.setEncryptedID(null);
        }
        if (nameId instanceof EncryptedID) {
            instance = (EncryptedID)nameId;
            subject.setNameID(null);
            subject.setEncryptedID((EncryptedID)instance);
        }
        if (subjectConfNameId instanceof NameID) {
            instance = (NameID)subjectConfNameId;
            subjectConfirmation.setNameID(instance);
            subjectConfirmation.setEncryptedID(null);
        }
        if (subjectConfNameId instanceof EncryptedID) {
            instance = (EncryptedID)subjectConfNameId;
            subjectConfirmation.setNameID(null);
            subjectConfirmation.setEncryptedID((EncryptedID)instance);
        }
        subject.getSubjectConfirmations().add(subjectConfirmation);
        LOGGER.debug("Built subject [{}]", (Object)subject);
        return subject;
    }

    public String decodeSamlAuthnRequest(String encodedRequestXmlString) {
        if (StringUtils.isEmpty((CharSequence)encodedRequestXmlString)) {
            return null;
        }
        byte[] decodedBytes = EncodingUtils.decodeBase64((String)encodedRequestXmlString);
        return this.inflateAuthnRequest(decodedBytes);
    }

    @Override
    public <T extends SAMLObject> T newSamlObject(Class<T> objectType) {
        QName qName = this.getSamlObjectQName(objectType);
        return SamlUtils.newSamlObject(objectType, qName);
    }

    protected Attribute newAttribute(String attributeFriendlyName, String attributeName, Object attributeValue, Map<String, String> configuredNameFormats, String defaultNameFormat, Map<String, String> attributeValueTypes) {
        Attribute attribute = this.newSamlObject(Attribute.class);
        attribute.setName(attributeName);
        if (StringUtils.isNotBlank((CharSequence)attributeFriendlyName)) {
            attribute.setFriendlyName(attributeFriendlyName);
        } else {
            attribute.setFriendlyName(attributeName);
        }
        String valueType = attributeValueTypes.get(attributeName);
        this.addAttributeValuesToSaml2Attribute(attributeName, attributeValue, valueType, attribute.getAttributeValues());
        if (!configuredNameFormats.isEmpty() && configuredNameFormats.containsKey(attribute.getName())) {
            String nameFormat = configuredNameFormats.get(attribute.getName());
            LOGGER.debug("Found name format [{}] for attribute [{}]", (Object)nameFormat, (Object)attribute.getName());
            AbstractSaml20ObjectBuilder.configureAttributeNameFormat(attribute, nameFormat);
            LOGGER.debug("Attribute [{}] is assigned the name format of [{}]", (Object)attribute.getName(), (Object)attribute.getNameFormat());
        } else {
            LOGGER.debug("Skipped name format, as no name formats are defined or none is found for attribute [{}]", (Object)attribute.getName());
            AbstractSaml20ObjectBuilder.configureAttributeNameFormat(attribute, defaultNameFormat);
        }
        LOGGER.debug("Attribute [{}] has [{}] value(s)", (Object)attribute.getName(), (Object)attribute.getAttributeValues().size());
        return attribute;
    }

    protected String inflateAuthnRequest(byte[] decodedBytes) {
        String inflated = CompressionUtils.inflate((byte[])decodedBytes);
        if (!StringUtils.isEmpty((CharSequence)inflated)) {
            return inflated;
        }
        return CompressionUtils.inflateToString((byte[])decodedBytes);
    }

    protected String getInResponseTo(RequestAbstractType request, String entityId, boolean skipInResponseTo) {
        boolean generateInResponseTo;
        boolean bl = generateInResponseTo = !skipInResponseTo && StringUtils.isNotBlank((CharSequence)request.getID());
        if (generateInResponseTo && request.getExtensions() != null) {
            List extensions = Optional.ofNullable(request.getExtensions()).map(ElementExtensibleXMLObject::getUnknownXMLObjects).orElseGet(List::of);
            generateInResponseTo = extensions.stream().filter(RequesterID.class::isInstance).map(RequesterID.class::cast).noneMatch(info -> entityId.equalsIgnoreCase(info.getURI()));
        }
        return generateInResponseTo ? request.getID() : null;
    }
}

