/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientOutputs;
import org.springframework.security.web.webauthn.api.CredentialPropertiesOutput;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientOutputs;

class AuthenticationExtensionsClientOutputsDeserializer
extends StdDeserializer<AuthenticationExtensionsClientOutputs> {
    private static final Log logger = LogFactory.getLog(AuthenticationExtensionsClientOutputsDeserializer.class);

    AuthenticationExtensionsClientOutputsDeserializer() {
        super(AuthenticationExtensionsClientOutputs.class);
    }

    public AuthenticationExtensionsClientOutputs deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonToken startObject;
        ArrayList outputs = new ArrayList();
        String key = parser.nextFieldName();
        while (key != null && (startObject = parser.nextValue()) == JsonToken.START_OBJECT) {
            if ("credProps".equals(key)) {
                CredentialPropertiesOutput output = (CredentialPropertiesOutput)parser.readValueAs(CredentialPropertiesOutput.class);
                outputs.add(output);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping unknown extension with id " + key));
                }
                parser.nextValue();
            }
            key = parser.nextFieldName();
        }
        return new ImmutableAuthenticationExtensionsClientOutputs(outputs);
    }
}

