/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ExecMessageModal;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.RemediationRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.any.AnyObjectWizardBuilder;
import org.apache.syncope.client.console.wizards.any.GroupWizardBuilder;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RemediationDirectoryPanel
extends DirectoryPanel<RemediationTO, RemediationTO, RemediationProvider, RemediationRestClient> {
    private static final long serialVersionUID = 8525204188127106587L;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected RoleRestClient roleRestClient;
    @SpringBean
    protected UserRestClient userRestClient;
    @SpringBean
    protected GroupRestClient groupRestClient;
    @SpringBean
    protected AnyObjectRestClient anyObjectRestClient;

    public RemediationDirectoryPanel(String id, RemediationRestClient restClient, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef, true);
        this.disableCheckBoxes();
        this.setFooterVisibility(false);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"REMEDIATION_REMEDY");
    }

    protected List<IColumn<RemediationTO, String>> getColumns() {
        ArrayList<IColumn<RemediationTO, String>> columns = new ArrayList<IColumn<RemediationTO, String>>();
        columns.add((IColumn<RemediationTO, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("operation"), (Object)"operation", "operation"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("anyType"), (Object)"anyType", "anyType"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("remoteName"), (Object)"remoteName", "remoteName"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("resource"), (Object)"resource", "resource"));
        columns.add((IColumn<RemediationTO, String>)new DatePropertyColumn((IModel)new ResourceModel("instant"), "instant", "instant"));
        return columns;
    }

    protected ActionsPanel<RemediationTO> getActions(final IModel<RemediationTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<RemediationTO>(this){
            private static final long serialVersionUID = 6193210574968203299L;
            final /* synthetic */ RemediationDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                this.this$0.modal.header((IModel)new ResourceModel("error"));
                this.this$0.modal.setContent((ModalPanel)new ExecMessageModal(((RemediationTO)model.getObject()).getError()));
                this.this$0.modal.show(true);
                target.add(new Component[]{this.this$0.modal});
            }
        }, ActionLink.ActionType.VIEW_DETAILS, "REMEDIATION_READ");
        if (((RemediationTO)model.getObject()).getOperation() == ResourceOperation.DELETE) {
            String entitlements = StringUtils.join((Object[])new String[]{"REMEDIATION_REMEDY", AnyTypeKind.USER.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "USER_DELETE" : (AnyTypeKind.GROUP.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "GROUP_DELETE" : AnyEntitlement.DELETE.getFor(((RemediationTO)model.getObject()).getAnyType()))}, (String)",");
            panel.add((ActionLink)new ActionLink<RemediationTO>(this){
                private static final long serialVersionUID = 6193210574968203299L;
                final /* synthetic */ RemediationDirectoryPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                    try {
                        ((RemediationRestClient)this.this$0.restClient).remedy(((RemediationTO)model.getObject()).getKey(), ((RemediationTO)model.getObject()).getKeyPayload());
                        SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                        target.add(new Component[]{this.this$0.container});
                    }
                    catch (SyncopeClientException e) {
                        DirectoryPanel.LOG.error("While performing remediation {}", (Object)((RemediationTO)model.getObject()).getKey(), (Object)e);
                        SyncopeConsoleSession.get().onException((Exception)((Object)e));
                    }
                    ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }, ActionLink.ActionType.CLOSE, entitlements, true);
        } else {
            String entitlements = ((RemediationTO)model.getObject()).getOperation() == ResourceOperation.CREATE ? StringUtils.join((Object[])new String[]{"REMEDIATION_REMEDY", AnyTypeKind.USER.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "USER_CREATE" : (AnyTypeKind.GROUP.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "GROUP_CREATE" : AnyEntitlement.CREATE.getFor(((RemediationTO)model.getObject()).getAnyType()))}, (String)",") : StringUtils.join((Object[])new String[]{"REMEDIATION_REMEDY", AnyTypeKind.USER.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "USER_UPDATE" : (AnyTypeKind.GROUP.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "GROUP_UPDATE" : AnyEntitlement.UPDATE.getFor(((RemediationTO)model.getObject()).getAnyType()))}, (String)",");
            panel.add((ActionLink)new ActionLink<RemediationTO>(this){
                private static final long serialVersionUID = 6193210574968203299L;
                final /* synthetic */ RemediationDirectoryPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                    this.this$0.modal.setFormModel((IModel)new CompoundPropertyModel((Object)((RemediationTO)model.getObject())));
                    RemediationTO remediationTO = (RemediationTO)model.getObject();
                    switch (remediationTO.getAnyType()) {
                        case "USER": {
                            UserTO previousUserTO;
                            UserTO newUserTO;
                            if (remediationTO.getAnyURPayload() == null) {
                                newUserTO = new UserTO();
                                EntityTOUtils.toAnyTO((AnyCR)remediationTO.getAnyCRPayload(), (AnyTO)newUserTO);
                                previousUserTO = null;
                            } else {
                                previousUserTO = (UserTO)this.this$0.userRestClient.read(remediationTO.getAnyURPayload().getKey());
                                newUserTO = AnyOperations.patch((UserTO)previousUserTO, (UserUR)((UserUR)remediationTO.getAnyURPayload()));
                            }
                            AjaxWizard.EditItemActionEvent userEvent = new AjaxWizard.EditItemActionEvent((Serializable)newUserTO, target);
                            userEvent.forceModalPanel((WizardModalPanel)this.this$0.new RemediationUserWizardBuilder((RemediationTO)model.getObject(), previousUserTO, newUserTO, this.this$0.anyTypeRestClient.read(remediationTO.getAnyType()).getClasses(), AnyLayoutUtils.fetch((RoleRestClient)this.this$0.roleRestClient, List.of(remediationTO.getAnyType())).getUser(), this.this$0.userRestClient, this.this$0.pageRef).build("content", AjaxWizard.Mode.EDIT));
                            this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, userEvent);
                            break;
                        }
                        case "GROUP": {
                            GroupTO previousGroupTO;
                            GroupTO newGroupTO;
                            if (remediationTO.getAnyURPayload() == null) {
                                newGroupTO = new GroupTO();
                                EntityTOUtils.toAnyTO((AnyCR)remediationTO.getAnyCRPayload(), (AnyTO)newGroupTO);
                                previousGroupTO = null;
                            } else {
                                previousGroupTO = (GroupTO)this.this$0.groupRestClient.read(remediationTO.getAnyURPayload().getKey());
                                newGroupTO = AnyOperations.patch((GroupTO)previousGroupTO, (GroupUR)((GroupUR)remediationTO.getAnyURPayload()));
                            }
                            AjaxWizard.EditItemActionEvent groupEvent = new AjaxWizard.EditItemActionEvent((Serializable)newGroupTO, target);
                            groupEvent.forceModalPanel((WizardModalPanel)this.this$0.new RemediationGroupWizardBuilder((RemediationTO)model.getObject(), previousGroupTO, newGroupTO, this.this$0.anyTypeRestClient.read(remediationTO.getAnyType()).getClasses(), AnyLayoutUtils.fetch((RoleRestClient)this.this$0.roleRestClient, List.of(remediationTO.getAnyType())).getGroup(), this.this$0.pageRef).build("content", AjaxWizard.Mode.EDIT));
                            this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, groupEvent);
                            break;
                        }
                        default: {
                            AnyObjectTO previousAnyObjectTO;
                            AnyObjectTO newAnyObjectTO;
                            if (remediationTO.getAnyURPayload() == null) {
                                newAnyObjectTO = new AnyObjectTO();
                                EntityTOUtils.toAnyTO((AnyCR)remediationTO.getAnyCRPayload(), (AnyTO)newAnyObjectTO);
                                previousAnyObjectTO = null;
                            } else {
                                previousAnyObjectTO = (AnyObjectTO)this.this$0.anyObjectRestClient.read(remediationTO.getAnyURPayload().getKey());
                                newAnyObjectTO = AnyOperations.patch((AnyObjectTO)previousAnyObjectTO, (AnyObjectUR)((AnyObjectUR)remediationTO.getAnyURPayload()));
                            }
                            AjaxWizard.EditItemActionEvent anyObjectEvent = new AjaxWizard.EditItemActionEvent((Serializable)newAnyObjectTO, target);
                            anyObjectEvent.forceModalPanel((WizardModalPanel)this.this$0.new RemediationAnyObjectWizardBuilder((RemediationTO)model.getObject(), previousAnyObjectTO, newAnyObjectTO, this.this$0.anyTypeRestClient.read(remediationTO.getAnyType()).getClasses(), (AnyObjectFormLayoutInfo)AnyLayoutUtils.fetch((RoleRestClient)this.this$0.roleRestClient, List.of(remediationTO.getAnyType())).getAnyObjects().get(remediationTO.getAnyType()), this.this$0.pageRef).build("content", AjaxWizard.Mode.EDIT));
                            this.this$0.send((IEventSink)this.this$0, Broadcast.EXACT, anyObjectEvent);
                        }
                    }
                }
            }, ActionLink.ActionType.EDIT, entitlements);
        }
        panel.add((ActionLink)new ActionLink<RemediationTO>(this){
            private static final long serialVersionUID = 6193210574968203299L;
            final /* synthetic */ RemediationDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                try {
                    ((RemediationRestClient)this.this$0.restClient).delete(((RemediationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((RemediationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "REMEDIATION_DELETE", true);
        return panel;
    }

    protected RemediationProvider dataProvider() {
        return new RemediationProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "remediation.paginator.rows";
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public class RemediationProvider
    extends DirectoryDataProvider<RemediationTO> {
        private static final long serialVersionUID = -2311716167583335852L;

        public RemediationProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("instant", SortOrder.ASCENDING);
        }

        public Iterator<RemediationTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).getRemediations((page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).countRemediations();
        }

        public IModel<RemediationTO> model(final RemediationTO remediation) {
            return new IModel<RemediationTO>(this){
                private static final long serialVersionUID = -2566070996511906708L;
                final /* synthetic */ RemediationProvider this$1;
                {
                    this.this$1 = this$1;
                }

                public RemediationTO getObject() {
                    return remediation;
                }
            };
        }
    }

    private class RemediationAnyObjectWizardBuilder
    extends AnyObjectWizardBuilder {
        private static final long serialVersionUID = 6993139499479015083L;
        private final AnyObjectTO previousAnyObjectTO;
        private final RemediationTO remediationTO;

        RemediationAnyObjectWizardBuilder(RemediationTO remediationTO, AnyObjectTO previousAnyObjectTO, AnyObjectTO anyObjectTO, List<String> anyTypeClasses, AnyObjectFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousAnyObjectTO, anyObjectTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.previousAnyObjectTO = previousAnyObjectTO;
            this.remediationTO = remediationTO;
        }

        protected Serializable onApplyInternal(AnyWrapper<AnyObjectTO> modelObject) {
            Object result;
            AnyObjectTO inner = (AnyObjectTO)modelObject.getInnerObject();
            if (this.remediationTO.getAnyURPayload() == null) {
                AnyObjectCR req = new AnyObjectCR();
                EntityTOUtils.toAnyCR((AnyTO)inner, (AnyCR)req);
                result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), req);
            } else {
                AnyObjectUR req = AnyOperations.diff((AnyObjectTO)inner, (AnyObjectTO)this.previousAnyObjectTO, (boolean)false);
                if (req.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), (AnyUR)req);
                }
            }
            return result;
        }
    }

    private class RemediationGroupWizardBuilder
    extends GroupWizardBuilder {
        private static final long serialVersionUID = -5233791906979150786L;
        private final GroupTO previousGroupTO;
        private final RemediationTO remediationTO;

        RemediationGroupWizardBuilder(RemediationTO remediationTO, GroupTO previousGroupTO, GroupTO groupTO, List<String> anyTypeClasses, GroupFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousGroupTO, groupTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.previousGroupTO = previousGroupTO;
            this.remediationTO = remediationTO;
        }

        protected Serializable onApplyInternal(AnyWrapper<GroupTO> modelObject) {
            Object result;
            GroupTO inner = (GroupTO)modelObject.getInnerObject();
            if (this.remediationTO.getAnyURPayload() == null) {
                GroupCR req = new GroupCR();
                EntityTOUtils.toAnyCR((AnyTO)inner, (AnyCR)req);
                result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), req);
            } else {
                GroupUR req = AnyOperations.diff((GroupTO)inner, (GroupTO)this.previousGroupTO, (boolean)false);
                if (req.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), (AnyUR)req);
                }
            }
            return result;
        }
    }

    private class RemediationUserWizardBuilder
    extends UserWizardBuilder {
        private static final long serialVersionUID = 6840699724316612700L;
        private final UserTO previousUserTO;
        private final RemediationTO remediationTO;

        RemediationUserWizardBuilder(RemediationTO remediationTO, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, UserRestClient userRestClient, PageReference pageRef) {
            super(previousUserTO, userTO, anyTypeClasses, formLayoutInfo, userRestClient, pageRef);
            this.previousUserTO = previousUserTO;
            this.remediationTO = remediationTO;
        }

        protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
            ProvisioningResult result;
            UserTO inner = (UserTO)modelObject.getInnerObject();
            if (this.remediationTO.getAnyURPayload() == null) {
                UserCR req = new UserCR();
                EntityTOUtils.toAnyCR((AnyTO)inner, (AnyCR)req);
                result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), req);
            } else {
                UserUR req = AnyOperations.diff((UserTO)inner, (UserTO)this.previousUserTO, (boolean)false);
                if (StringUtils.isNotBlank((CharSequence)inner.getPassword())) {
                    PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(true).resources((Collection)inner.getResources()).build();
                    req.setPassword(passwordPatch);
                }
                if (req.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), (AnyUR)req);
                }
            }
            return result;
        }
    }
}

