/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.AggregateAuthenticationHandler;
import org.ldaptive.auth.AggregateDnResolver;
import org.ldaptive.auth.AggregateEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationRequestHandler;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.auth.NoOpEntryResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.ldaptive.auth.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Authenticator
extends AbstractFreezable {
    private static final EntryResolver NO_OP_RESOLVER = new NoOpEntryResolver();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DnResolver dnResolver;
    private AuthenticationHandler authenticationHandler;
    private EntryResolver entryResolver;
    private String[] returnAttributes;
    private AuthenticationRequestHandler[] requestHandlers;
    private AuthenticationResponseHandler[] responseHandlers;
    private boolean resolveEntryOnFailure;

    public Authenticator() {
    }

    public Authenticator(DnResolver resolver, AuthenticationHandler handler) {
        this.setDnResolver(resolver);
        this.setAuthenticationHandler(handler);
    }

    @Override
    public void freeze() {
        super.freeze();
        Authenticator.freeze(this.dnResolver);
        Authenticator.freeze(this.authenticationHandler);
        Authenticator.freeze(this.entryResolver);
        Authenticator.freeze(this.requestHandlers);
        Authenticator.freeze(this.responseHandlers);
    }

    public DnResolver getDnResolver() {
        return this.dnResolver;
    }

    public void setDnResolver(DnResolver resolver) {
        this.assertMutable();
        this.dnResolver = resolver;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler handler) {
        this.assertMutable();
        this.authenticationHandler = handler;
    }

    public EntryResolver getEntryResolver() {
        return this.entryResolver;
    }

    public void setEntryResolver(EntryResolver resolver) {
        this.assertMutable();
        this.entryResolver = resolver;
    }

    public boolean getResolveEntryOnFailure() {
        return this.resolveEntryOnFailure;
    }

    public void setResolveEntryOnFailure(boolean b) {
        this.assertMutable();
        this.resolveEntryOnFailure = b;
    }

    public String[] getReturnAttributes() {
        return LdapUtils.copyArray(this.returnAttributes);
    }

    public void setReturnAttributes(String ... attrs) {
        this.assertMutable();
        this.returnAttributes = LdapUtils.copyArray(attrs);
    }

    public AuthenticationRequestHandler[] getRequestHandlers() {
        return LdapUtils.copyArray(this.requestHandlers);
    }

    public void setRequestHandlers(AuthenticationRequestHandler ... handlers) {
        this.assertMutable();
        this.requestHandlers = LdapUtils.copyArray(handlers);
    }

    public AuthenticationResponseHandler[] getResponseHandlers() {
        return LdapUtils.copyArray(this.responseHandlers);
    }

    public void setResponseHandlers(AuthenticationResponseHandler ... handlers) {
        this.assertMutable();
        this.responseHandlers = LdapUtils.copyArray(handlers);
    }

    public String resolveDn(User user) throws LdapException {
        return this.dnResolver.resolve(user);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest request) throws LdapException {
        return this.authenticate(this.resolveDn(request.getUser()), request);
    }

    public void close() {
        Map<String, AuthenticationHandler> handlers;
        Map<String, Object> resolvers;
        HashSet<ConnectionFactoryManager> managers = new HashSet<ConnectionFactoryManager>();
        if (this.dnResolver instanceof ConnectionFactoryManager) {
            managers.add((ConnectionFactoryManager)((Object)this.dnResolver));
        } else if (this.dnResolver instanceof AggregateDnResolver && (resolvers = ((AggregateDnResolver)this.dnResolver).getDnResolvers()) != null) {
            resolvers.values().stream().filter(ConnectionFactoryManager.class::isInstance).map(ConnectionFactoryManager.class::cast).forEach(managers::add);
        }
        if (this.authenticationHandler instanceof ConnectionFactoryManager) {
            managers.add((ConnectionFactoryManager)((Object)this.authenticationHandler));
        } else if (this.authenticationHandler instanceof AggregateAuthenticationHandler && (handlers = ((AggregateAuthenticationHandler)this.authenticationHandler).getAuthenticationHandlers()) != null) {
            handlers.values().stream().filter(ConnectionFactoryManager.class::isInstance).map(ConnectionFactoryManager.class::cast).forEach(managers::add);
        }
        if (this.entryResolver instanceof ConnectionFactoryManager) {
            managers.add((ConnectionFactoryManager)((Object)this.entryResolver));
        } else if (this.entryResolver instanceof AggregateEntryResolver && (resolvers = ((AggregateEntryResolver)this.entryResolver).getEntryResolvers()) != null) {
            resolvers.values().stream().filter(ConnectionFactoryManager.class::isInstance).map(ConnectionFactoryManager.class::cast).forEach(managers::add);
        }
        if (!managers.isEmpty()) {
            this.closeConnectionFactoryManagers(managers);
        }
    }

    private void closeConnectionFactoryManagers(Set<ConnectionFactoryManager> managers) {
        if (managers != null) {
            managers.stream().filter(Objects::nonNull).map(ConnectionFactoryManager::getConnectionFactory).filter(Objects::nonNull).distinct().forEach(cf -> {
                try {
                    cf.close();
                }
                catch (Exception e) {
                    this.logger.debug("Error closing connection factory {}", cf, (Object)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResponse authenticate(String dn, AuthenticationRequest request) throws LdapException {
        LdapEntry entry;
        this.logger.trace("authenticate dn={} with request={}", (Object)dn, (Object)request);
        AuthenticationResponse invalidInput = this.validateInput(dn, request);
        if (invalidInput != null) {
            invalidInput.freeze();
            return invalidInput;
        }
        AuthenticationRequest processedRequest = this.processRequest(dn, request);
        AuthenticationHandlerResponse response = null;
        try {
            AuthenticationCriteria ac = new AuthenticationCriteria(dn, processedRequest);
            response = this.getAuthenticationHandler().authenticate(ac);
            entry = this.resolveEntry(ac, response);
        }
        finally {
            if (response != null && response.getConnection() != null) {
                response.getConnection().close();
            }
        }
        if (response == null) {
            throw new IllegalStateException("Authentication response is null");
        }
        this.logger.info("Authentication {} for dn: {}", (Object)(response.isSuccess() ? "succeeded" : "failed"), (Object)dn);
        AuthenticationResponse authResponse = new AuthenticationResponse(response, dn, entry);
        if (this.responseHandlers != null && this.responseHandlers.length > 0) {
            for (AuthenticationResponseHandler ah : this.responseHandlers) {
                ah.handle(authResponse);
            }
        }
        authResponse.freeze();
        this.logger.debug("Authenticate response={} for dn={} with request={}", new Object[]{response, dn, processedRequest});
        return authResponse;
    }

    private AuthenticationResponse validateInput(String dn, AuthenticationRequest request) {
        AuthenticationResponse response = null;
        Credential credential = request.getCredential();
        if (credential == null || credential.isNull()) {
            response = (AuthenticationResponse)AuthenticationResponse.builder().response((AuthenticationHandlerResponse)((AuthenticationHandlerResponse.Builder)AuthenticationHandlerResponse.builder().diagnosticMessage("Credential cannot be null")).resultCode(AuthenticationResultCode.INVALID_CREDENTIAL).build()).dn(dn).build();
        } else if (credential.isEmpty()) {
            response = (AuthenticationResponse)AuthenticationResponse.builder().response((AuthenticationHandlerResponse)((AuthenticationHandlerResponse.Builder)AuthenticationHandlerResponse.builder().diagnosticMessage("Credential cannot be empty")).resultCode(AuthenticationResultCode.INVALID_CREDENTIAL).build()).dn(dn).build();
        } else if (dn == null) {
            response = (AuthenticationResponse)AuthenticationResponse.builder().response((AuthenticationHandlerResponse)((AuthenticationHandlerResponse.Builder)AuthenticationHandlerResponse.builder().diagnosticMessage("DN cannot be null")).resultCode(AuthenticationResultCode.DN_RESOLUTION_FAILURE).build()).dn(null).build();
        } else if (dn.isEmpty()) {
            response = (AuthenticationResponse)AuthenticationResponse.builder().response((AuthenticationHandlerResponse)((AuthenticationHandlerResponse.Builder)AuthenticationHandlerResponse.builder().diagnosticMessage("DN cannot be empty")).resultCode(AuthenticationResultCode.DN_RESOLUTION_FAILURE).build()).dn(dn).build();
        }
        return response;
    }

    private AuthenticationRequest processRequest(String dn, AuthenticationRequest request) throws LdapException {
        if (this.returnAttributes == null && (this.requestHandlers == null || this.requestHandlers.length == 0)) {
            return request;
        }
        AuthenticationRequest newRequest = AuthenticationRequest.copy(request);
        if (this.returnAttributes != null) {
            if (newRequest.getReturnAttributes() == null || ReturnAttributes.NONE.equalsAttributes(newRequest.getReturnAttributes())) {
                newRequest.setReturnAttributes(this.returnAttributes);
            } else {
                newRequest.setReturnAttributes(LdapUtils.concatArrays(newRequest.getReturnAttributes(), new String[][]{this.returnAttributes}));
            }
        }
        if (this.requestHandlers != null && this.requestHandlers.length > 0) {
            for (AuthenticationRequestHandler ah : this.requestHandlers) {
                ah.handle(dn, newRequest);
            }
        }
        return newRequest;
    }

    private LdapEntry resolveEntry(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) throws LdapException {
        LdapEntry entry = null;
        if (this.resolveEntryOnFailure || response.isSuccess()) {
            EntryResolver er = this.entryResolver != null ? this.entryResolver : (!ReturnAttributes.NONE.equalsAttributes(criteria.getAuthenticationRequest().getReturnAttributes()) ? (this.dnResolver instanceof AggregateDnResolver ? ((AggregateDnResolver)this.dnResolver).createEntryResolver(new SearchEntryResolver()) : new SearchEntryResolver()) : NO_OP_RESOLVER);
            try {
                entry = er.resolve(criteria, response);
                this.logger.trace("resolved entry={} with resolver={}", (Object)entry, (Object)er);
            }
            catch (LdapException e) {
                this.logger.warn("Entry resolution failed for resolver={}", (Object)er, (Object)e);
            }
        }
        if (entry == null) {
            entry = NO_OP_RESOLVER.resolve(criteria, response);
            this.logger.trace("resolved entry={} with resolver={}", (Object)entry, (Object)NO_OP_RESOLVER);
        }
        return entry;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::dnResolver=" + String.valueOf(this.dnResolver) + ", authenticationHandler=" + String.valueOf(this.authenticationHandler) + ", entryResolver=" + String.valueOf(this.entryResolver) + ", returnAttributes=" + Arrays.toString(this.returnAttributes) + ", requestHandlers=" + Arrays.toString(this.requestHandlers) + ", responseHandlers=" + Arrays.toString(this.responseHandlers) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Authenticator object = new Authenticator();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder dnResolver(DnResolver resolver) {
            this.object.setDnResolver(resolver);
            return this;
        }

        public Builder authenticationHandler(AuthenticationHandler handler) {
            this.object.setAuthenticationHandler(handler);
            return this;
        }

        public Builder entryResolver(EntryResolver resolver) {
            this.object.setEntryResolver(resolver);
            return this;
        }

        public Builder requestHandlers(AuthenticationRequestHandler ... handlers) {
            this.object.setRequestHandlers(handlers);
            return this;
        }

        public Builder responseHandlers(AuthenticationResponseHandler ... handlers) {
            this.object.setResponseHandlers(handlers);
            return this;
        }

        public Builder returnAttributes(String ... attributes) {
            this.object.setReturnAttributes(attributes);
            return this;
        }

        public Authenticator build() {
            return this.object;
        }
    }
}

