/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;

public final class InternalClientAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean capturePort;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalClientAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean capturePort, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.capturePort = capturePort;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (clientAddressAndPort.address != null) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.CLIENT_ADDRESS, (Object)clientAddressAndPort.address);
                if (this.capturePort && clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.CLIENT_PORT, (Object)clientAddressAndPort.port);
                }
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_CLIENT_IP, (Object)clientAddressAndPort.address);
            }
        }
    }
}

