/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.inject.ConfigException;
import io.smallrye.config.inject.InjectionMessages;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;

public class InjectionMessages_$bundle
implements InjectionMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final InjectionMessages_$bundle INSTANCE = new InjectionMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected InjectionMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String noConfigValue$str() {
        return "SRCFG02000: Failed to Inject @ConfigProperty for key %s into %s since the config property could not be found in any config source";
    }

    @Override
    public final ConfigException noConfigValue(String configPropertyName, String location) {
        ConfigException result = new ConfigException(String.format(this.getLoggingLocale(), this.noConfigValue$str(), configPropertyName, location), configPropertyName);
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String retrieveConfigFailure$str() {
        return "SRCFG02001: Failed to Inject @ConfigProperty for key %s into %s %s";
    }

    @Override
    public final ConfigException retrieveConfigFailure(String configPropertyName, String location, String causeMessage, Exception e) {
        ConfigException result = new ConfigException(String.format(this.getLoggingLocale(), this.retrieveConfigFailure$str(), configPropertyName, location, causeMessage), configPropertyName, e);
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noConfigPropertyDefaultName$str() {
        return "SRCFG02002: Could not find default name for @ConfigProperty InjectionPoint %s";
    }

    @Override
    public final IllegalStateException noConfigPropertyDefaultName(InjectionPoint injectionPoint) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noConfigPropertyDefaultName$str(), injectionPoint));
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unhandledConfigProperty$str() {
        return "SRCFG02003: Unhandled ConfigProperty";
    }

    @Override
    public final IllegalStateException unhandledConfigProperty() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unhandledConfigProperty$str(), new Object[0]));
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertyNotFound$str() {
        return "SRCFG02004: Required property %s not found";
    }

    @Override
    public final NoSuchElementException propertyNotFound(String name) {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.propertyNotFound$str(), name));
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noRawType$str() {
        return "SRCFG02005: Type has no raw type class: %s";
    }

    @Override
    public final IllegalArgumentException noRawType(Type type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noRawType$str(), type));
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalConversion$str() {
        return "SRCFG02006: The property %s cannot be converted to %s";
    }

    @Override
    public final IllegalArgumentException illegalConversion(String name, Type type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalConversion$str(), name, type));
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noRegisteredConverter$str() {
        return "SRCFG02007: No Converter registered for %s";
    }

    @Override
    public final IllegalArgumentException noRegisteredConverter(Class<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noRegisteredConverter$str(), type));
        InjectionMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

