/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementIsolator;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RutaRuleElement
extends AbstractRuleElement {
    private RutaMatcher matcher;
    protected final InferenceCrowd emptyCrowd = new InferenceCrowd(Collections.EMPTY_LIST);

    public RutaRuleElement(RutaMatcher matcher, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions, RuleElementContainer container, RutaBlock parent) {
        super(quantifier, conditions, actions, container, parent);
        this.matcher = matcher;
    }

    @Override
    public Collection<? extends AnnotationFS> getAnchors(RutaStream stream) {
        return this.matcher.getMatchingAnnotations(this.getParent(), stream);
    }

    @Override
    public List<RuleMatch> startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        ArrayList<RuleMatch> result = new ArrayList<RuleMatch>();
        Collection<? extends AnnotationFS> anchors = this.getAnchors(stream);
        boolean useAlternatives = anchors.size() != 1;
        for (AnnotationFS annotationFS : anchors) {
            ((RutaRule)ruleMatch.getRule()).clearOwnLabels();
            if (this.earlyExit(annotationFS, ruleApply, stream)) continue;
            ComposedRuleElementMatch extendedContainerMatch = containerMatch;
            RuleMatch extendedMatch = ruleMatch;
            if (useAlternatives) {
                extendedContainerMatch = containerMatch.copy();
                extendedMatch = ruleMatch.copy(extendedContainerMatch, true);
            }
            this.doMatch(true, annotationFS, extendedMatch, extendedContainerMatch, true, stream, crowd);
            if (this.equals(entryPoint) && ruleApply == null) {
                result.add(extendedMatch);
                continue;
            }
            if (extendedMatch.matched()) {
                List<RuleMatch> continueMatch;
                RuleElement after = this.getContainer().getNextElement(true, this);
                RuleElement before = this.getContainer().getNextElement(false, this);
                RutaRuleElement sideStepOrigin = this.hasAncestor(false) ? this : null;
                MatchContext context = new MatchContext(this, extendedMatch, true);
                if (this.quantifier.continueMatch(true, context, annotationFS, extendedContainerMatch, stream, crowd)) {
                    List<RuleMatch> continueOwnMatch = this.continueOwnMatch(true, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(continueOwnMatch);
                    continue;
                }
                if (after != null) {
                    sideStepOrigin = this.hasAncestor(false) ? this : null;
                    continueMatch = after.continueMatch(true, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(continueMatch);
                } else if ((stream.isDynamicAnchoring() || this.isStartAnchor()) && before != null) {
                    sideStepOrigin = this.hasAncestor(true) ? this : null;
                    continueMatch = before.continueMatch(false, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(continueMatch);
                }
                if (after != null || before != null) continue;
                if (this.getContainer() instanceof ComposedRuleElement) {
                    sideStepOrigin = this.hasAncestor(false) ? this : null;
                    ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
                    List<RuleMatch> fallbackContinue = composed.fallbackContinue(true, false, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(fallbackContinue);
                    continue;
                }
                if (!(this.getContainer() instanceof RuleElementIsolator)) continue;
                this.doneMatching(extendedMatch, ruleApply, stream, crowd);
                continue;
            }
            if (!(this.getContainer() instanceof ComposedRuleElement)) continue;
            ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
            List<RuleMatch> fallbackContinue = composed.fallbackContinue(true, true, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, null, entryPoint, stream, crowd);
            result.addAll(fallbackContinue);
        }
        return result;
    }

    @Override
    public List<RuleMatch> continueOwnMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<Object> result = new ArrayList();
        MatchContext context = new MatchContext(this, ruleMatch, after);
        if (this.quantifier.continueMatch(after, context, annotation, containerMatch, stream, crowd)) {
            boolean stopMatching = false;
            AnnotationFS eachAnchor = annotation;
            AnnotationFS lastAnchor = annotation;
            ComposedRuleElementMatch extendedContainerMatch = containerMatch;
            RuleMatch extendedMatch = ruleMatch;
            while (!stopMatching) {
                context = new MatchContext(this, extendedMatch, after);
                if (!this.quantifier.continueMatch(after, context, eachAnchor, extendedContainerMatch, stream, crowd)) {
                    stopMatching = true;
                    this.stepbackMatch(after, lastAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                    break;
                }
                Collection<? extends AnnotationFS> nextAnnotations = this.getNextAnnotations(after, eachAnchor, stream);
                if (nextAnnotations.size() == 0) {
                    stopMatching = true;
                    result = this.stepbackMatch(after, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                    continue;
                }
                if (nextAnnotations.size() == 1) {
                    lastAnchor = eachAnchor;
                    eachAnchor = nextAnnotations.iterator().next();
                    this.doMatch(after, eachAnchor, extendedMatch, extendedContainerMatch, false, stream, crowd);
                    if (this.equals(entryPoint)) {
                        result.add(extendedMatch);
                        continue;
                    }
                    if (extendedMatch.matched()) {
                        if (this.quantifier.continueMatch(after, context, eachAnchor, extendedContainerMatch, stream, crowd)) continue;
                        stopMatching = true;
                        result = this.continueMatchSomewhereElse(after, false, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                        continue;
                    }
                    stopMatching = true;
                    result = this.stepbackMatch(after, lastAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                    continue;
                }
                stopMatching = true;
                result = this.continueMatch(after, lastAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
            }
        } else {
            result = this.stepbackMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd, entryPoint);
        }
        return result;
    }

    protected List<RuleMatch> continueMatchSomewhereElse(boolean after, boolean failed, AnnotationFS eachAnchor, RuleMatch extendedMatch, RuleApply ruleApply, ComposedRuleElementMatch extendedContainerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        RuleElement nextRuleElement = this.getContainer().getNextElement(after, this);
        if (nextRuleElement != null) {
            result = nextRuleElement.continueMatch(after, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
        } else if (sideStepOrigin != null && !failed && this.containedIn(sideStepOrigin, this.getContainer())) {
            result = sideStepOrigin.continueSideStep(after, extendedMatch, ruleApply, extendedContainerMatch, entryPoint, stream, crowd);
        } else if (this.getContainer() instanceof ComposedRuleElement) {
            ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
            result = composed.fallbackContinue(after, failed, eachAnchor, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
        }
        return result;
    }

    private boolean containedIn(RuleElement sideStepOrigin, RuleElementContainer container) {
        if (container == null || sideStepOrigin == null) {
            return false;
        }
        List<RuleElement> ruleElements = container.getRuleElements();
        if (ruleElements.contains(sideStepOrigin)) {
            return true;
        }
        for (RuleElement ruleElement : ruleElements) {
            if (!(ruleElement instanceof RuleElementContainer) || !this.containedIn(sideStepOrigin, (RuleElementContainer)((Object)ruleElement))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<RuleMatch> continueMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        List<Object> result = new ArrayList();
        MatchContext context = new MatchContext(this, ruleMatch, after);
        if (this.quantifier.continueMatch(after, context, annotation, containerMatch, stream, crowd)) {
            Collection<? extends AnnotationFS> nextAnnotations = this.getNextAnnotations(after, annotation, stream);
            if (this.isNotConsumable(nextAnnotations)) {
                result = this.stepbackMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd, entryPoint);
            }
            boolean useAlternatives = nextAnnotations.size() > 1;
            for (AnnotationFS annotationFS : nextAnnotations) {
                if (this.earlyExit(annotationFS, ruleApply, stream)) continue;
                ComposedRuleElementMatch extendedContainerMatch = containerMatch;
                RuleMatch extendedMatch = ruleMatch;
                if (useAlternatives) {
                    extendedContainerMatch = containerMatch.copy();
                    extendedMatch = ruleMatch.copy(extendedContainerMatch, after);
                }
                this.doMatch(after, annotationFS, extendedMatch, extendedContainerMatch, false, stream, crowd);
                if (this.equals(entryPoint) && ruleApply == null) {
                    result.add(extendedMatch);
                    continue;
                }
                if (extendedMatch.matched()) {
                    context = new MatchContext(this, extendedMatch, after);
                    if (this.quantifier.continueMatch(after, context, annotationFS, extendedContainerMatch, stream, crowd)) {
                        List<RuleMatch> continueOwnMatch = this.continueOwnMatch(after, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                        result.addAll(continueOwnMatch);
                        continue;
                    }
                    List<RuleMatch> continueMatchSomewhereElse = this.continueMatchSomewhereElse(after, false, annotationFS, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, entryPoint, stream, crowd);
                    result.addAll(continueMatchSomewhereElse);
                    continue;
                }
                if (this.equals(entryPoint)) {
                    result.add(extendedMatch);
                    continue;
                }
                List<RuleMatch> stepbackMatch = this.stepbackMatch(after, annotation, extendedMatch, ruleApply, extendedContainerMatch, sideStepOrigin, stream, crowd, entryPoint);
                result.addAll(stepbackMatch);
            }
        } else {
            result = this.stepbackMatch(after, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, stream, crowd, entryPoint);
        }
        return result;
    }

    protected boolean isNotConsumable(Collection<? extends AnnotationFS> nextAnnotations) {
        return nextAnnotations.isEmpty();
    }

    protected List<RuleMatch> stepbackMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement sideStepOrigin, RutaStream stream, InferenceCrowd crowd, RuleElement entryPoint) {
        List<RuleMatch> result = new ArrayList<RuleMatch>();
        if (this.equals(entryPoint) && ruleApply == null) {
            result.add(ruleMatch);
            return result;
        }
        List<RuleElementMatch> matchInfo = this.getMatch(ruleMatch, containerMatch);
        MatchContext context = new MatchContext(this, ruleMatch, after);
        if (matchInfo == null) {
            context.getParent().getEnvironment().addMatchToVariable(ruleMatch, this, context, stream);
            if (this.quantifier.isOptional(context, stream)) {
                result = this.continueMatchSomewhereElse(after, false, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
            } else if (this.getContainer() instanceof ComposedRuleElement) {
                ComposedRuleElement cre = (ComposedRuleElement)this.getContainer();
                result = cre.fallbackContinue(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
            }
        } else {
            List<RuleElementMatch> evaluateMatches = this.quantifier.evaluateMatches(matchInfo, context, stream, crowd);
            ruleMatch.setMatched(evaluateMatches != null);
            if (ruleMatch.matched()) {
                result = this.continueMatchSomewhereElse(after, false, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
            } else if (this.getContainer() instanceof ComposedRuleElement) {
                ComposedRuleElement composed = (ComposedRuleElement)this.getContainer();
                List<RuleMatch> fallbackContinue = composed.fallbackContinue(after, true, annotation, ruleMatch, ruleApply, containerMatch, sideStepOrigin, entryPoint, stream, crowd);
                result.addAll(fallbackContinue);
            } else {
                this.doneMatching(ruleMatch, ruleApply, stream, crowd);
            }
        }
        return result;
    }

    @Override
    public void doMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, boolean ruleAnchor, RutaStream stream, InferenceCrowd crowd) {
        RuleElementMatch result = new RuleElementMatch(this, containerMatch);
        result.setRuleAnchor(ruleAnchor);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        boolean base = true;
        MatchContext context = new MatchContext(annotation, this, ruleMatch, after);
        List<AnnotationFS> textsMatched = annotation != null ? Arrays.asList(annotation) : Collections.emptyList();
        result.setMatchInfo(base, textsMatched, stream);
        RutaEnvironment environment = context.getParent().getEnvironment();
        environment.addMatchToVariable(ruleMatch, this, context, stream);
        if (base) {
            for (AbstractRutaCondition condition : this.conditions) {
                crowd.beginVisit(condition, null);
                EvaluatedCondition eval = condition.eval(context, stream, crowd);
                crowd.endVisit(condition, null);
                evaluatedConditions.add(eval);
                if (eval.isValue()) continue;
                break;
            }
        }
        result.setConditionInfo(base, evaluatedConditions);
        if (result.matched()) {
            boolean inlinedRulesMatched = this.matchInlinedRules(ruleMatch, result, stream, crowd);
            result.setInlinedRulesMatched(inlinedRulesMatched);
        } else {
            environment.removeVariableValue(this.getLabel(), context);
        }
        ruleMatch.setMatched(ruleMatch.matched() && result.matched());
    }

    public String toString() {
        String simpleName = this.getQuantifier().getClass().getSimpleName();
        return this.matcher.toString() + " " + (simpleName.equals("NormalQuantifier") ? "" : simpleName);
    }

    public RutaMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public List<AbstractRutaCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public List<AbstractRutaAction> getActions() {
        return this.actions;
    }

    @Override
    public RutaBlock getParent() {
        return this.parent;
    }

    @Override
    public long estimateAnchors(RutaStream stream) {
        if (this.quantifier.isOptional(null, stream)) {
            return this.matcher.estimateAnchors(this.parent, stream) + Integer.MAX_VALUE;
        }
        return this.matcher.estimateAnchors(this.parent, stream);
    }

    public Collection<? extends AnnotationFS> getNextAnnotations(boolean after, AnnotationFS annotation, RutaStream stream) {
        if (after) {
            return this.matcher.getAnnotationsAfter(this, annotation, this.getParent(), stream);
        }
        return this.matcher.getAnnotationsBefore(this, annotation, this.getParent(), stream);
    }
}

