/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SelectFSs;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.SelectFSs_impl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.jcas.cas.TOP;

public interface LowLevelIndex<T extends FeatureStructure>
extends FSIndex<T> {
    public static final Comparator<TOP> FS_ID_COMPARATOR = (fs1, fs2) -> Integer.compare(fs1._id, fs2._id);
    public static final boolean IS_ORDERED = false;
    public static final boolean IS_TYPE_ORDER = false;

    default public LowLevelIterator<T> ll_iterator() {
        return this.ll_iterator(true);
    }

    public LowLevelIterator<T> ll_iterator(boolean var1);

    default public int ll_compare(int ref1, int ref2) {
        CASImpl cas = this.getCasImpl();
        return this.compare((FeatureStructure)cas.getFsFromId_checked(ref1), (FeatureStructure)cas.getFsFromId_checked(ref2));
    }

    public CASImpl getCasImpl();

    public FSIndexComparator getComparatorForIndexSpecs();

    public Comparator<TOP> getComparator();

    default public void flush() {
        throw new UnsupportedOperationException();
    }

    default public IntPointerIterator getIntIterator() {
        return new IntPointerIterator(){
            private LowLevelIterator<T> it;
            {
                this.it = LowLevelIndex.this.ll_iterator();
            }

            @Override
            public boolean isValid() {
                return this.it.isValid();
            }

            @Override
            public int get() {
                return this.it.ll_get();
            }

            @Override
            public void inc() {
                this.it.moveToNext();
            }

            @Override
            public void dec() {
                this.it.moveToPrevious();
            }

            @Override
            public void moveTo(int i) {
                this.it.moveTo(i);
            }

            @Override
            public void moveToFirst() {
                this.it.moveToFirst();
            }

            @Override
            public void moveToLast() {
                this.it.moveToLast();
            }

            @Override
            public Object copy() {
                IntPointerIterator newIt = LowLevelIndex.this.getIntIterator();
                if (this.isValid()) {
                    newIt.moveTo(this.it.ll_get());
                } else {
                    newIt.moveToFirst();
                    newIt.dec();
                }
                return newIt;
            }
        };
    }

    default public <U extends T> LowLevelIndex<U> getSubIndex(Type type) {
        TypeImpl ti = (TypeImpl)type;
        return this.getCasImpl().indexRepository.getIndexBySpec(ti.getCode(), this.getIndexingStrategy(), (FSIndexComparatorImpl)this.getComparatorForIndexSpecs());
    }

    default public <U extends T> LowLevelIndex<U> getSubIndex(Class<? extends TOP> clazz) {
        return this.getSubIndex(this.getCasImpl().getCasType(clazz));
    }

    public int ll_maxAnnotSpan();

    public boolean isSorted();

    @Override
    default public SelectFSs<T> select() {
        return ((SelectFSs_impl)this.getCasImpl().select()).index(this);
    }

    @Override
    default public <N extends T> SelectFSs<N> select(Type type) {
        return ((SelectFSs_impl)this.select()).type(type);
    }

    @Override
    default public <N extends T> SelectFSs<N> select(Class<N> clazz) {
        return ((SelectFSs_impl)this.select()).type(clazz);
    }

    @Override
    default public <N extends T> SelectFSs<N> select(int jcasType) {
        return ((SelectFSs_impl)this.select()).type(jcasType);
    }

    @Override
    default public <N extends T> SelectFSs<N> select(String fullyQualifiedTypeName) {
        return ((SelectFSs_impl)this.select()).type(fullyQualifiedTypeName);
    }

    @Override
    default public LowLevelIterator<T> iterator() {
        return this.iterator(false, false);
    }

    public LowLevelIterator<T> iterator(boolean var1, boolean var2);
}

