/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.wicket.protocol.http.servlet.ResponseIOException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;

public class PartWriterCallback
extends AbstractResource.WriteCallback {
    private final InputStream inputStream;
    private final Long contentLength;
    private Long startbyte;
    private Long endbyte;
    private int bufferSize;
    private boolean close = false;

    public PartWriterCallback(InputStream inputStream, Long contentLength, Long startbyte, Long endbyte) {
        this.inputStream = inputStream;
        this.contentLength = (Long)Args.notNull((Object)contentLength, (String)"contentLength");
        this.startbyte = startbyte;
        this.endbyte = endbyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(IResource.Attributes attributes) throws IOException {
        block10: {
            try {
                OutputStream outputStream = attributes.getResponse().getOutputStream();
                byte[] buffer = new byte[this.getBufferSize()];
                if (this.startbyte != null || this.endbyte != null) {
                    if (this.startbyte != null) {
                        this.inputStream.skip(this.startbyte);
                    } else {
                        this.startbyte = 0L;
                    }
                    if (this.endbyte == null || Long.valueOf(-1L).equals(this.endbyte)) {
                        this.endbyte = this.contentLength;
                    }
                    BoundedInputStream boundedInputStream = null;
                    try {
                        int readBytes;
                        boundedInputStream = new BoundedInputStream(this.inputStream, this.endbyte - this.startbyte + 1L);
                        boundedInputStream.setPropagateClose(false);
                        while ((readBytes = boundedInputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, readBytes);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(boundedInputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)boundedInputStream);
                    break block10;
                }
                Streams.copy((InputStream)this.inputStream, (OutputStream)outputStream, (int)this.getBufferSize());
            }
            catch (ResponseIOException responseIOException) {
                // empty catch block
            }
        }
        if (this.close) {
            IOUtils.close((Closeable)this.inputStream);
        }
    }

    public int getBufferSize() {
        return this.bufferSize > 0 ? this.bufferSize : 4096;
    }

    public PartWriterCallback setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public boolean isClose() {
        return this.close;
    }

    public PartWriterCallback setClose(boolean close) {
        this.close = close;
        return this;
    }
}

