/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node;

import java.io.IOException;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.node.NodeResourceUsageStats;

public class NodesResourceUsageStats
implements Writeable,
ToXContentFragment {
    private final Map<String, NodeResourceUsageStats> nodeIdToResourceUsageStatsMap;

    public NodesResourceUsageStats(Map<String, NodeResourceUsageStats> nodeIdToResourceUsageStatsMap) {
        this.nodeIdToResourceUsageStatsMap = nodeIdToResourceUsageStatsMap;
    }

    public NodesResourceUsageStats(StreamInput in) throws IOException {
        this.nodeIdToResourceUsageStatsMap = in.readMap(StreamInput::readString, NodeResourceUsageStats::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.nodeIdToResourceUsageStatsMap, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
    }

    public Map<String, NodeResourceUsageStats> getNodeIdToResourceUsageStatsMap() {
        return this.nodeIdToResourceUsageStatsMap;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("resource_usage_stats");
        for (String nodeId : this.nodeIdToResourceUsageStatsMap.keySet()) {
            NodeResourceUsageStats resourceUsageStats = this.nodeIdToResourceUsageStatsMap.get(nodeId);
            resourceUsageStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

