/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent.smile;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactoryBuilder;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;
import org.opensearch.common.xcontent.XContentContraints;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.smile.SmileXContentGenerator;
import org.opensearch.common.xcontent.smile.SmileXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentGenerator;
import org.opensearch.core.xcontent.XContentParser;

public class SmileXContent
implements XContent,
XContentContraints {
    static final SmileFactory smileFactory;
    public static final SmileXContent smileXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder((XContent)smileXContent);
    }

    private SmileXContent() {
    }

    public MediaType mediaType() {
        return XContentType.SMILE;
    }

    public byte streamSeparator() {
        return -1;
    }

    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new SmileXContentGenerator((JsonGenerator)smileFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(content));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, (JsonParser)smileFactory.createParser(is));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, (JsonParser)smileFactory.createParser(data));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, (JsonParser)smileFactory.createParser(data, offset, length));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(reader));
    }

    static {
        SmileFactoryBuilder builder = new SmileFactoryBuilder(new SmileFactory());
        builder.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        smileFactory = builder.build();
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        smileFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        smileFactory.setStreamWriteConstraints(StreamWriteConstraints.builder().maxNestingDepth(DEFAULT_MAX_DEPTH).build());
        smileFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(DEFAULT_MAX_STRING_LEN).maxNameLength(DEFAULT_MAX_NAME_LEN).maxNestingDepth(DEFAULT_MAX_DEPTH).build());
        smileFactory.configure(StreamReadFeature.USE_FAST_DOUBLE_PARSER.mappedFeature(), true);
        smileXContent = new SmileXContent();
    }
}

