"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * CSP modifications config schema for dynamic config service.
 */
const config = exports.config = {
  path: 'csp-modifications',
  schema: _configSchema.schema.object({
    modifications: _configSchema.schema.arrayOf(_configSchema.schema.object({
      directive: _configSchema.schema.string(),
      action: _configSchema.schema.oneOf([_configSchema.schema.literal('add'), _configSchema.schema.literal('remove'), _configSchema.schema.literal('set')]),
      values: _configSchema.schema.arrayOf(_configSchema.schema.string())
    }), {
      defaultValue: []
    })
  })
};