"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throwFacetError = exports.removeKeyword = exports.isPPLSearchQuery = exports.handleQueryStatus = exports.getFields = exports.formatDate = exports.fetch = exports.buildQueryStatusConfig = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _std = require("@osd/std");
var _constants = require("./constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const formatDate = dateString => {
  const date = new Date(dateString);
  return date.getFullYear() + '-' + ('0' + (date.getMonth() + 1)).slice(-2) + '-' + ('0' + date.getDate()).slice(-2) + ' ' + ('0' + date.getHours()).slice(-2) + ':' + ('0' + date.getMinutes()).slice(-2) + ':' + ('0' + date.getSeconds()).slice(-2) + '.' + ('00' + date.getMilliseconds()).slice(-3);
};
exports.formatDate = formatDate;
const getFields = rawResponse => {
  var _rawResponse$data$sch;
  return (_rawResponse$data$sch = rawResponse.data.schema) === null || _rawResponse$data$sch === void 0 ? void 0 : _rawResponse$data$sch.map((field, index) => {
    var _rawResponse$data$dat;
    return {
      ...field,
      values: (_rawResponse$data$dat = rawResponse.data.datarows) === null || _rawResponse$data$dat === void 0 ? void 0 : _rawResponse$data$dat.map(row => row[index])
    };
  });
};
exports.getFields = getFields;
const removeKeyword = queryString => {
  var _queryString$replace;
  return (_queryString$replace = queryString === null || queryString === void 0 ? void 0 : queryString.replace(new RegExp('.keyword'), '')) !== null && _queryString$replace !== void 0 ? _queryString$replace : '';
};
exports.removeKeyword = removeKeyword;
const throwFacetError = response => {
  var _ref, _response$data$body$m, _response$data$body, _ref2, _response$data$status;
  let errorMessage = (_ref = (_response$data$body$m = (_response$data$body = response.data.body) === null || _response$data$body === void 0 ? void 0 : _response$data$body.message) !== null && _response$data$body$m !== void 0 ? _response$data$body$m : response.data.body) !== null && _ref !== void 0 ? _ref : response.data;

  // Check if errorMessage is an object and handle Error objects
  if (typeof errorMessage === 'object') {
    if (errorMessage instanceof Error) {
      // If errorMessage is an instance of Error, extract its message
      errorMessage = errorMessage.message;
    } else if (errorMessage.message) {
      // If errorMessage has a message property, extract that message
      errorMessage = JSON.stringify(errorMessage.message);
    } else {
      // If errorMessage is a plain object, stringify it
      errorMessage = JSON.stringify(errorMessage);
    }
  }
  const error = new Error(errorMessage);
  error.name = (_ref2 = (_response$data$status = response.data.status) !== null && _response$data$status !== void 0 ? _response$data$status : response.status) !== null && _ref2 !== void 0 ? _ref2 : response.data.statusCode;
  error.status = error.name;
  throw error;
};
exports.throwFacetError = throwFacetError;
const fetch = (context, query, aggConfig) => {
  var _context$body, _context$body2;
  const {
    http,
    path,
    signal
  } = context;
  const body = (0, _std.stringify)({
    query: {
      ...query,
      format: 'jdbc'
    },
    aggConfig,
    pollQueryResultsParams: (_context$body = context.body) === null || _context$body === void 0 ? void 0 : _context$body.pollQueryResultsParams,
    timeRange: (_context$body2 = context.body) === null || _context$body2 === void 0 ? void 0 : _context$body2.timeRange
  });
  return (0, _rxjs.from)(http.fetch({
    method: 'POST',
    path,
    body,
    signal
  }).catch(async error => {
    var _context$body3;
    if (error.name === 'AbortError' && (_context$body3 = context.body) !== null && _context$body3 !== void 0 && (_context$body3 = _context$body3.pollQueryResultsParams) !== null && _context$body3 !== void 0 && _context$body3.queryId) {
      // Cancel job
      try {
        var _query$dataset, _context$body4;
        await http.fetch({
          method: 'DELETE',
          path: _constants.API.DATA_SOURCE.ASYNC_JOBS,
          query: {
            id: (_query$dataset = query.dataset) === null || _query$dataset === void 0 || (_query$dataset = _query$dataset.dataSource) === null || _query$dataset === void 0 ? void 0 : _query$dataset.id,
            queryId: (_context$body4 = context.body) === null || _context$body4 === void 0 ? void 0 : _context$body4.pollQueryResultsParams.queryId
          }
        });
      } catch (cancelError) {
        // eslint-disable-next-line no-console
        console.error('Failed to cancel query:', cancelError);
      }
    }
    throw error;
  }));
};
exports.fetch = fetch;
const handleQueryStatus = options => {
  const {
    fetchStatus,
    interval = 5000,
    isServer = false
  } = options;
  return (0, _rxjs.timer)(0, interval).pipe((0, _operators.mergeMap)(() => fetchStatus()), (0, _operators.takeWhile)(response => {
    var _data, _status;
    const status = isServer ? response === null || response === void 0 || (_data = response.data) === null || _data === void 0 || (_data = _data.status) === null || _data === void 0 ? void 0 : _data.toUpperCase() : response === null || response === void 0 || (_status = response.status) === null || _status === void 0 ? void 0 : _status.toUpperCase();
    return status !== 'SUCCESS' && status !== 'FAILED';
  }, true), (0, _operators.filter)(response => {
    var _data2, _status2;
    const status = isServer ? response === null || response === void 0 || (_data2 = response.data) === null || _data2 === void 0 || (_data2 = _data2.status) === null || _data2 === void 0 ? void 0 : _data2.toUpperCase() : response === null || response === void 0 || (_status2 = response.status) === null || _status2 === void 0 ? void 0 : _status2.toUpperCase();
    if (status === 'FAILED') {
      throw new Error('Job failed');
    }
    return status === 'SUCCESS';
  }), (0, _operators.take)(1)).toPromise();
};
exports.handleQueryStatus = handleQueryStatus;
const buildQueryStatusConfig = response => {
  return {
    queryId: response.data.queryId,
    sessionId: response.data.sessionId
  };
};

/**
 * Test if a PPL query is using search command
 * https://github.com/opensearch-project/sql/blob/main/docs/user/ppl/cmd/search.md
 */
exports.buildQueryStatusConfig = buildQueryStatusConfig;
const isPPLSearchQuery = query => {
  if (query.language !== 'PPL') {
    return false;
  }
  if (typeof query.query !== 'string') {
    return false;
  }
  const string = query.query.toLowerCase().replace(/\s/g, '');
  return string.startsWith('source=') || string.startsWith('searchsource=');
};
exports.isPPLSearchQuery = isPPLSearchQuery;