/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyState {
    CREATING("Creating"),
    ENABLED("Enabled"),
    DISABLED("Disabled"),
    PENDING_DELETION("PendingDeletion"),
    PENDING_IMPORT("PendingImport"),
    PENDING_REPLICA_DELETION("PendingReplicaDeletion"),
    UNAVAILABLE("Unavailable"),
    UPDATING("Updating"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyState> VALUE_MAP;
    private final String value;

    private KeyState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyState> knownValues() {
        EnumSet<KeyState> knownValues = EnumSet.allOf(KeyState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyState.class, KeyState::toString);
    }
}

