/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.pbe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.util.io.Streams;
import org.cryptacular.CryptUtil;
import org.cryptacular.CryptoException;
import org.cryptacular.pbe.EncryptionScheme;

public abstract class AbstractEncryptionScheme
implements EncryptionScheme {
    private BufferedBlockCipher cipher;
    private CipherParameters parameters;

    @Override
    public byte[] encrypt(byte[] plaintext) {
        CryptUtil.assertNotNullArg(plaintext, "Plain text cannot be null");
        this.cipher.init(true, this.parameters);
        return this.process(plaintext);
    }

    @Override
    public void encrypt(InputStream in, OutputStream out) throws IOException {
        CryptUtil.assertNotNullArg(in, "Input stream cannot be null");
        CryptUtil.assertNotNullArg(out, "Output stream cannot be null");
        this.cipher.init(true, this.parameters);
        Streams.pipeAll((InputStream)in, (OutputStream)new CipherOutputStream(out, this.cipher));
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        CryptUtil.assertNotNullArg(ciphertext, "Cipher text cannot be null");
        this.cipher.init(false, this.parameters);
        return this.process(ciphertext);
    }

    @Override
    public void decrypt(InputStream in, OutputStream out) throws IOException {
        CryptUtil.assertNotNullArg(in, "Input stream cannot be null");
        CryptUtil.assertNotNullArg(out, "Output stream cannot be null");
        this.cipher.init(false, this.parameters);
        Streams.pipeAll((InputStream)new CipherInputStream(in, this.cipher), (OutputStream)out);
    }

    @Override
    public OutputStream wrap(boolean encryptionFlag, OutputStream out) {
        CryptUtil.assertNotNullArg(out, "Output stream cannot be null");
        this.cipher.init(encryptionFlag, this.parameters);
        return new CipherOutputStream(out, this.cipher);
    }

    protected void setCipher(BufferedBlockCipher bufferedBlockCipher) {
        this.cipher = CryptUtil.assertNotNullArg(bufferedBlockCipher, "Block cipher cannot be null");
    }

    protected void setCipherParameters(CipherParameters parameters) {
        this.parameters = CryptUtil.assertNotNullArg(parameters, "Cipher parameters cannot be null");
    }

    private byte[] process(byte[] input) {
        byte[] output = new byte[this.cipher.getOutputSize(input.length)];
        int processed = this.cipher.processBytes(input, 0, input.length, output, 0);
        try {
            processed += this.cipher.doFinal(output, processed);
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException("Cipher error", e);
        }
        return Arrays.copyOfRange(output, 0, processed);
    }
}

