from collections.abc import Iterator
from typing import Any

from django.contrib.gis.geos.geometry import GEOSGeometry, LinearGeometryMixin

class GeometryCollection(GEOSGeometry):
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def __iter__(self) -> Iterator[GEOSGeometry]: ...
    def __len__(self) -> int: ...
    @property
    def coords(self) -> tuple[Any, ...]: ...
    @property
    def tuple(self) -> tuple[Any, ...]: ...

class MultiPoint(GeometryCollection): ...
class MultiLineString(LinearGeometryMixin, GeometryCollection): ...
class MultiPolygon(GeometryCollection): ...
