/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation.options;

import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputFormatState;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public enum OperationsOutputFormat implements OutputFormat
{
    text("Plain text format", "txt"),
    html("HyperText Markup Language (HTML) format"),
    json("JavaScript Object Notation (JSON) serialization format");

    private static final Logger LOGGER;
    private final OutputFormatState outputFormatState;

    public static OperationsOutputFormat fromFormat(String format) {
        OperationsOutputFormat outputFormat = OperationsOutputFormat.fromFormatOrNull(format);
        if (outputFormat == null) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Unknown format <%s>, using default", new Object[]{format}));
            return json;
        }
        return outputFormat;
    }

    public static boolean isSupportedFormat(String format) {
        return OperationsOutputFormat.fromFormatOrNull(format) != null;
    }

    private static OperationsOutputFormat fromFormatOrNull(String format) {
        if (Utility.isBlank((String)format)) {
            return null;
        }
        for (OperationsOutputFormat outputFormat : OperationsOutputFormat.values()) {
            if (!outputFormat.outputFormatState.isSupportedFormat(format)) continue;
            return outputFormat;
        }
        return null;
    }

    private OperationsOutputFormat(String description) {
        this.outputFormatState = new OutputFormatState(this.name(), description, new String[0]);
    }

    private OperationsOutputFormat(String description, String formatSpecifier) {
        this.outputFormatState = new OutputFormatState(formatSpecifier, description, new String[]{this.name()});
    }

    public String getDescription() {
        return this.outputFormatState.getDescription();
    }

    public String getFormat() {
        return this.outputFormatState.getFormat();
    }

    public List<String> getFormats() {
        return this.outputFormatState.getFormats();
    }

    public String toString() {
        return this.outputFormatState.toString();
    }

    static {
        LOGGER = Logger.getLogger(OperationsOutputFormat.class.getName());
    }
}

