/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.WeakRefModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.referencetype.PReferenceType;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(defineModule="_weakref", isEager=true)
public final class WeakRefModuleBuiltins
extends PythonBuiltins {
    private final ReferenceQueue<Object> weakRefQueue = new ReferenceQueue();
    private static final TruffleString T_PROXY_TYPE = PythonUtils.tsLiteral("ProxyType");
    private static final TruffleString T_CALLABLE_PROXY_TYPE = PythonUtils.tsLiteral("CallableProxyType");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return WeakRefModuleBuiltinsFactory.getFactories();
    }

    public static int getBuiltinTypeWeaklistoffset(PythonBuiltinClassType cls) {
        return switch (cls) {
            case PythonBuiltinClassType.PythonClass -> 368;
            case PythonBuiltinClassType.PSet, PythonBuiltinClassType.PFrozenSet -> 192;
            case PythonBuiltinClassType.PMemoryView, PythonBuiltinClassType.PCode -> 136;
            case PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.PGenerator, PythonBuiltinClassType.PCoroutine, PythonBuiltinClassType.PythonModule, PythonBuiltinClassType.PThreadLocal, PythonBuiltinClassType.PRLock, PythonBuiltinClassType.PBufferedRWPair, PythonBuiltinClassType.PAsyncGenerator, PythonBuiltinClassType.PGenericAlias -> 40;
            case PythonBuiltinClassType.PMethod, PythonBuiltinClassType.PFileIO, PythonBuiltinClassType.PTee -> 32;
            case PythonBuiltinClassType.PFunction -> 80;
            case PythonBuiltinClassType.PIOBase, PythonBuiltinClassType.PRawIOBase, PythonBuiltinClassType.PBufferedIOBase, PythonBuiltinClassType.PTextIOBase, PythonBuiltinClassType.PLock -> 24;
            case PythonBuiltinClassType.PBytesIO, PythonBuiltinClassType.PPartial -> 48;
            case PythonBuiltinClassType.PStringIO -> 112;
            case PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedRandom, PythonBuiltinClassType.PLruCacheWrapper -> 144;
            case PythonBuiltinClassType.PickleBuffer -> 96;
            case PythonBuiltinClassType.PTextIOWrapper -> 176;
            case PythonBuiltinClassType.POrderedDict -> 104;
            default -> 0;
        };
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule weakrefModule = core.lookupBuiltinModule(BuiltinNames.T__WEAKREF);
        HiddenAttr.WriteNode.executeUncached(weakrefModule, HiddenAttr.WEAK_REF_QUEUE, this.weakRefQueue);
        PythonBuiltinClass refType = core.lookupType(PythonBuiltinClassType.PReferenceType);
        weakrefModule.setAttribute(StringLiterals.T_REF, refType);
        HiddenAttr.WriteNode.executeUncached(refType, HiddenAttr.WEAK_REF_QUEUE, this.weakRefQueue);
        TypeNodes.SetTypeFlagsNode.executeUncached(weakrefModule.getAttribute(T_PROXY_TYPE), 16384L);
        TypeNodes.SetTypeFlagsNode.executeUncached(weakrefModule.getAttribute(T_CALLABLE_PROXY_TYPE), 16384L);
        PythonContext ctx = core.getContext();
        core.getContext().registerAsyncAction(() -> {
            if (!ctx.getGcState().isEnabled()) {
                return null;
            }
            Reference<Object> reference = null;
            if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
                try {
                    reference = this.weakRefQueue.remove();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                reference = this.weakRefQueue.poll();
            }
            ArrayList<PReferenceType.WeakRefStorage> refs = new ArrayList<PReferenceType.WeakRefStorage>();
            do {
                if (!(reference instanceof PReferenceType.WeakRefStorage)) continue;
                PReferenceType.WeakRefStorage ref = (PReferenceType.WeakRefStorage)reference;
                long ptr = ref.getPointer();
                if (ptr > 0L) {
                    if (ctx.isFinalizing()) continue;
                    refs.add(ref);
                    CApiTransitions.removeNativeWeakRef(ctx, ptr);
                    continue;
                }
                refs.add(ref);
            } while ((reference = this.weakRefQueue.poll()) != null);
            if (!refs.isEmpty()) {
                return new WeakrefCallbackAction(refs.toArray(new PReferenceType.WeakRefStorage[0]));
            }
            return null;
        });
    }

    private static class WeakrefCallbackAction
    extends AsyncHandler.AsyncPythonAction {
        private final PReferenceType.WeakRefStorage[] references;
        private int index;

        public WeakrefCallbackAction(PReferenceType.WeakRefStorage[] weakRefStorages) {
            this.references = weakRefStorages;
            this.index = 0;
        }

        @Override
        public Object callable() {
            return this.references[this.index].getCallback();
        }

        @Override
        public Object[] arguments() {
            return new Object[]{this.references[this.index].getRef()};
        }

        @Override
        public boolean proceed() {
            ++this.index;
            return this.index < this.references.length;
        }

        @Override
        protected void handleException(PException e) {
            WriteUnraisableNode.getUncached().execute(e.getEscapedException(), null, this.callable());
        }
    }

    @Builtin(name="_remove_dead_weakref", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RemoveDeadWeakRefsNode
    extends PythonBuiltinNode {
        @Specialization
        public Object removeDeadRefs(PDict dict, Object key) {
            return PNone.NONE;
        }
    }

    @Builtin(name="getweakrefs", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetWeakRefsNode
    extends PythonBuiltinNode {
        @Specialization
        public Object getRefs(Object object) {
            return PNone.NONE;
        }
    }

    @Builtin(name="getweakrefcount", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetWeakRefCountNode
    extends PythonBuiltinNode {
        @Specialization
        public Object getCount(PReferenceType pReferenceType) {
            return pReferenceType.getWeakRefCount();
        }

        @Fallback
        public Object getCount(Object none) {
            return 0;
        }
    }
}

