﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wisdom/ConnectWisdomService_EXPORTS.h>
#include <aws/wisdom/model/ExternalSourceConfiguration.h>
#include <aws/wisdom/model/ImportJobStatus.h>
#include <aws/wisdom/model/ImportJobType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectWisdomService {
namespace Model {

/**
 * <p>Summary information about the import job.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ImportJobSummary">AWS
 * API Reference</a></p>
 */
class ImportJobSummary {
 public:
  AWS_CONNECTWISDOMSERVICE_API ImportJobSummary() = default;
  AWS_CONNECTWISDOMSERVICE_API ImportJobSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTWISDOMSERVICE_API ImportJobSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTWISDOMSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The timestamp when the import job was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  ImportJobSummary& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration information of the external source that the resource data
   * are imported from.</p>
   */
  inline const ExternalSourceConfiguration& GetExternalSourceConfiguration() const { return m_externalSourceConfiguration; }
  inline bool ExternalSourceConfigurationHasBeenSet() const { return m_externalSourceConfigurationHasBeenSet; }
  template <typename ExternalSourceConfigurationT = ExternalSourceConfiguration>
  void SetExternalSourceConfiguration(ExternalSourceConfigurationT&& value) {
    m_externalSourceConfigurationHasBeenSet = true;
    m_externalSourceConfiguration = std::forward<ExternalSourceConfigurationT>(value);
  }
  template <typename ExternalSourceConfigurationT = ExternalSourceConfiguration>
  ImportJobSummary& WithExternalSourceConfiguration(ExternalSourceConfigurationT&& value) {
    SetExternalSourceConfiguration(std::forward<ExternalSourceConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the import job.</p>
   */
  inline const Aws::String& GetImportJobId() const { return m_importJobId; }
  inline bool ImportJobIdHasBeenSet() const { return m_importJobIdHasBeenSet; }
  template <typename ImportJobIdT = Aws::String>
  void SetImportJobId(ImportJobIdT&& value) {
    m_importJobIdHasBeenSet = true;
    m_importJobId = std::forward<ImportJobIdT>(value);
  }
  template <typename ImportJobIdT = Aws::String>
  ImportJobSummary& WithImportJobId(ImportJobIdT&& value) {
    SetImportJobId(std::forward<ImportJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of import job.</p>
   */
  inline ImportJobType GetImportJobType() const { return m_importJobType; }
  inline bool ImportJobTypeHasBeenSet() const { return m_importJobTypeHasBeenSet; }
  inline void SetImportJobType(ImportJobType value) {
    m_importJobTypeHasBeenSet = true;
    m_importJobType = value;
  }
  inline ImportJobSummary& WithImportJobType(ImportJobType value) {
    SetImportJobType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
   */
  inline const Aws::String& GetKnowledgeBaseArn() const { return m_knowledgeBaseArn; }
  inline bool KnowledgeBaseArnHasBeenSet() const { return m_knowledgeBaseArnHasBeenSet; }
  template <typename KnowledgeBaseArnT = Aws::String>
  void SetKnowledgeBaseArn(KnowledgeBaseArnT&& value) {
    m_knowledgeBaseArnHasBeenSet = true;
    m_knowledgeBaseArn = std::forward<KnowledgeBaseArnT>(value);
  }
  template <typename KnowledgeBaseArnT = Aws::String>
  ImportJobSummary& WithKnowledgeBaseArn(KnowledgeBaseArnT&& value) {
    SetKnowledgeBaseArn(std::forward<KnowledgeBaseArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES
   * type knowledge base if you're storing Wisdom Content resource to it.</p>
   */
  inline const Aws::String& GetKnowledgeBaseId() const { return m_knowledgeBaseId; }
  inline bool KnowledgeBaseIdHasBeenSet() const { return m_knowledgeBaseIdHasBeenSet; }
  template <typename KnowledgeBaseIdT = Aws::String>
  void SetKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    m_knowledgeBaseIdHasBeenSet = true;
    m_knowledgeBaseId = std::forward<KnowledgeBaseIdT>(value);
  }
  template <typename KnowledgeBaseIdT = Aws::String>
  ImportJobSummary& WithKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    SetKnowledgeBaseId(std::forward<KnowledgeBaseIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the import job was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  ImportJobSummary& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata fields of the imported Wisdom resources.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetMetadata() const { return m_metadata; }
  inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }
  template <typename MetadataT = Aws::Map<Aws::String, Aws::String>>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Aws::Map<Aws::String, Aws::String>>
  ImportJobSummary& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  template <typename MetadataKeyT = Aws::String, typename MetadataValueT = Aws::String>
  ImportJobSummary& AddMetadata(MetadataKeyT&& key, MetadataValueT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata.emplace(std::forward<MetadataKeyT>(key), std::forward<MetadataValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the import job.</p>
   */
  inline ImportJobStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ImportJobStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ImportJobSummary& WithStatus(ImportJobStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A pointer to the uploaded asset. This value is returned by <a
   * href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
   */
  inline const Aws::String& GetUploadId() const { return m_uploadId; }
  inline bool UploadIdHasBeenSet() const { return m_uploadIdHasBeenSet; }
  template <typename UploadIdT = Aws::String>
  void SetUploadId(UploadIdT&& value) {
    m_uploadIdHasBeenSet = true;
    m_uploadId = std::forward<UploadIdT>(value);
  }
  template <typename UploadIdT = Aws::String>
  ImportJobSummary& WithUploadId(UploadIdT&& value) {
    SetUploadId(std::forward<UploadIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdTime{};

  ExternalSourceConfiguration m_externalSourceConfiguration;

  Aws::String m_importJobId;

  ImportJobType m_importJobType{ImportJobType::NOT_SET};

  Aws::String m_knowledgeBaseArn;

  Aws::String m_knowledgeBaseId;

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::Map<Aws::String, Aws::String> m_metadata;

  ImportJobStatus m_status{ImportJobStatus::NOT_SET};

  Aws::String m_uploadId;
  bool m_createdTimeHasBeenSet = false;
  bool m_externalSourceConfigurationHasBeenSet = false;
  bool m_importJobIdHasBeenSet = false;
  bool m_importJobTypeHasBeenSet = false;
  bool m_knowledgeBaseArnHasBeenSet = false;
  bool m_knowledgeBaseIdHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_metadataHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_uploadIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectWisdomService
}  // namespace Aws
