/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.finder.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedList;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedListItem;

public class AdvancedListViewer
extends StructuredViewer {
    private static final Log log = Log.getLog(AdvancedListViewer.class);
    private AdvancedList control;

    public AdvancedListViewer(Composite parent, int style) {
        this.control = new AdvancedList(parent, style);
        this.control.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedListViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AdvancedListViewer.this, AdvancedListViewer.this.getSelection()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AdvancedListViewer.this.fireDoubleClick(new DoubleClickEvent((Viewer)AdvancedListViewer.this, AdvancedListViewer.this.getSelection()));
            }
        });
        this.control.addPaintListener(e -> {
            ViewerFilter[] filters = this.getFilters();
            if (this.control.getItems().length == 0 && filters != null && filters.length > 0) {
                UIUtils.drawMessageOverControl((Control)this.control, e, "No items found", 0);
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List<Object> getSelectionFromWidget() {
        ArrayList<Object> list = new ArrayList<Object>();
        AdvancedListItem item = this.control.getSelectedItem();
        if (item != null) {
            list.add(item.getData());
        }
        return list;
    }

    protected void internalRefresh(Object element) {
        this.control.removeAll();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        Object[] elements = contentProvider.getElements(element);
        for (ViewerFilter viewerFilter : this.getFilters()) {
            elements = viewerFilter.filter((Viewer)this, null, elements);
        }
        for (Object object : elements) {
            new AdvancedListItem(this.control, object, labelProvider);
        }
        this.control.redraw();
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.internalRefresh(this.getInput());
    }

    public void setFilters(ViewerFilter ... filters) {
        super.setFilters(filters);
        this.control.refreshFilters();
    }

    public void resetFilters() {
        super.resetFilters();
        this.control.refreshFilters();
    }
}

