/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.selection;

import java.util.Objects;
import java.util.UUID;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.maps.AvailableMaps;
import org.freeplane.plugin.ai.tools.selection.SelectionCollectionMode;
import org.freeplane.plugin.ai.tools.selection.SelectionIdentifiersBuilder;
import org.freeplane.plugin.ai.tools.selection.SelectionIdentifiersRequest;
import org.freeplane.plugin.ai.tools.selection.SelectionIdentifiersResponse;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryFormatter;

public class SelectedMapAndNodeIdentifiersTool {
    private final AvailableMaps availableMaps;
    private final AvailableMaps.MapAccessListener mapAccessListener;
    private final SelectionIdentifiersBuilder selectionIdentifiersBuilder;

    public SelectedMapAndNodeIdentifiersTool(AvailableMaps availableMaps, AvailableMaps.MapAccessListener mapAccessListener, TextController textController) {
        this.availableMaps = Objects.requireNonNull(availableMaps, "availableMaps");
        this.mapAccessListener = mapAccessListener;
        this.selectionIdentifiersBuilder = new SelectionIdentifiersBuilder(textController);
    }

    public SelectionIdentifiersResponse getSelectedMapAndNodeIdentifiers(SelectionIdentifiersRequest request) {
        UUID mapIdentifier = this.availableMaps.getCurrentMapIdentifier();
        MapModel mapModel = this.availableMaps.getCurrentMapModel();
        if (mapIdentifier != null && mapModel != null && this.mapAccessListener != null) {
            this.mapAccessListener.onMapAccessed(mapIdentifier, mapModel);
        }
        String mapIdentifierValue = mapIdentifier == null ? null : mapIdentifier.toString();
        IMapSelection selection = Controller.getCurrentController().getSelection();
        SelectionCollectionMode selectionCollectionMode = request == null ? null : request.getSelectionCollectionMode();
        return this.selectionIdentifiersBuilder.buildSelectionIdentifiersResponse(mapIdentifierValue, mapModel, selection, selectionCollectionMode);
    }

    public ToolCallSummary buildToolCallSummary(SelectionIdentifiersResponse response) {
        return new ToolCallSummary("getSelectedMapAndNodeIdentifiers", "getSelectedMapAndNodeIdentifiers: selected identifiers read", false);
    }

    public ToolCallSummary buildToolCallErrorSummary(RuntimeException error) {
        String message = error == null ? "Unknown error" : error.getMessage();
        String safeMessage = ToolCallSummaryFormatter.sanitizeValue(message == null ? error.getClass().getSimpleName() : message);
        return new ToolCallSummary("getSelectedMapAndNodeIdentifiers", "getSelectedMapAndNodeIdentifiers error: " + safeMessage, true);
    }
}

