/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.BitSet;
import java.util.HashMap;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class Block {
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private int itsBlockID;
    private BitSet itsLiveOnEntrySet;
    private BitSet itsLiveOnExitSet;
    private BitSet itsUseBeforeDefSet;
    private BitSet itsNotDefSet;
    static final boolean DEBUG = false;
    private static int debug_blockCount;

    Block(int n, int n2) {
        this.itsStartNodeIndex = n;
        this.itsEndNodeIndex = n2;
    }

    static void runFlowAnalyzes(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n;
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = optFunctionNode.fnode.getParamAndVarCount();
        int[] nArray = new int[n3];
        for (n = 0; n != n2; ++n) {
            nArray[n] = 3;
        }
        for (n = n2; n != n3; ++n) {
            nArray[n] = 0;
        }
        Block[] blockArray = Block.buildBlocks(nodeArray);
        Block.reachingDefDataFlow(optFunctionNode, nodeArray, blockArray, nArray);
        Block.typeFlow(optFunctionNode, nodeArray, blockArray, nArray);
        for (int i = n2; i != n3; ++i) {
            if (nArray[i] != 1) continue;
            optFunctionNode.setIsNumberVar(i);
        }
    }

    private static Block[] buildBlocks(Node[] nodeArray) {
        Object object;
        FatBlock fatBlock;
        int n;
        HashMap<Node, FatBlock> hashMap = new HashMap<Node, FatBlock>();
        ObjArray objArray = new ObjArray();
        int n2 = 0;
        block4: for (n = 0; n < nodeArray.length; ++n) {
            switch (nodeArray[n].getType()) {
                case 135: {
                    if (n == n2) continue block4;
                    fatBlock = Block.newFatBlock(n2, n - 1);
                    if (nodeArray[n2].getType() == 135) {
                        hashMap.put(nodeArray[n2], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n2 = n;
                    continue block4;
                }
                case 5: 
                case 6: 
                case 7: {
                    fatBlock = Block.newFatBlock(n2, n);
                    if (nodeArray[n2].getType() == 135) {
                        hashMap.put(nodeArray[n2], fatBlock);
                    }
                    objArray.add(fatBlock);
                    n2 = n + 1;
                }
            }
        }
        if (n2 != nodeArray.length) {
            FatBlock fatBlock2 = Block.newFatBlock(n2, nodeArray.length - 1);
            if (nodeArray[n2].getType() == 135) {
                hashMap.put(nodeArray[n2], fatBlock2);
            }
            objArray.add(fatBlock2);
        }
        for (n = 0; n < objArray.size(); ++n) {
            Object object2;
            fatBlock = (FatBlock)objArray.get(n);
            object = nodeArray[fatBlock.realBlock.itsEndNodeIndex];
            int n3 = ((Node)object).getType();
            if (n3 != 5 && n < objArray.size() - 1) {
                object2 = (FatBlock)objArray.get(n + 1);
                fatBlock.addSuccessor((FatBlock)object2);
                ((FatBlock)object2).addPredecessor(fatBlock);
            }
            if (n3 != 7 && n3 != 6 && n3 != 5) continue;
            object2 = ((Jump)object).target;
            FatBlock fatBlock3 = (FatBlock)hashMap.get(object2);
            ((Node)object2).putProp(6, fatBlock3.realBlock);
            fatBlock.addSuccessor(fatBlock3);
            fatBlock3.addPredecessor(fatBlock);
        }
        Block[] blockArray = new Block[objArray.size()];
        for (int i = 0; i < objArray.size(); ++i) {
            object = (FatBlock)objArray.get(i);
            Block block = ((FatBlock)object).realBlock;
            block.itsSuccessors = ((FatBlock)object).getSuccessors();
            block.itsPredecessors = ((FatBlock)object).getPredecessors();
            block.itsBlockID = i;
            blockArray[i] = block;
        }
        return blockArray;
    }

    private static FatBlock newFatBlock(int n, int n2) {
        FatBlock fatBlock = new FatBlock();
        fatBlock.realBlock = new Block(n, n2);
        return fatBlock;
    }

    private static String toString(Block[] blockArray, Node[] nodeArray) {
        return null;
    }

    private static void reachingDefDataFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        for (Block bl : blockArray) {
            bl.initLiveOnEntrySets(optFunctionNode, nodeArray);
        }
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = blockArray.length - 1;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doReachedUseDataFlow() && (blockArray2 = blockArray[n].itsPredecessors) != null) {
                    for (Block block : blockArray2) {
                        int n2 = block.itsBlockID;
                        blArray[n2] = true;
                        bl |= n2 > n;
                    }
                }
            }
            if (n == 0) {
                if (!bl) break;
                n = blockArray.length - 1;
                bl = false;
                continue;
            }
            --n;
        }
        blockArray[0].markAnyTypeVariables(nArray);
    }

    private static void typeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        int n = 0;
        boolean bl = false;
        blArray[n] = true;
        while (true) {
            if (blArray[n] || !blArray2[n]) {
                Block[] blockArray2;
                blArray2[n] = true;
                blArray[n] = false;
                if (blockArray[n].doTypeFlow(optFunctionNode, nodeArray, nArray) && (blockArray2 = blockArray[n].itsSuccessors) != null) {
                    for (Block block : blockArray2) {
                        int n2 = block.itsBlockID;
                        blArray[n2] = true;
                        bl |= n2 < n;
                    }
                }
            }
            if (n == blockArray.length - 1) {
                if (!bl) break;
                n = 0;
                bl = false;
                continue;
            }
            ++n;
        }
    }

    private static boolean assignType(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        int n4 = n;
        int n5 = nArray[n4] | n2;
        nArray[n4] = n5;
        return n3 != n5;
    }

    private void markAnyTypeVariables(int[] nArray) {
        for (int i = 0; i != nArray.length; ++i) {
            if (!this.itsLiveOnEntrySet.get(i)) continue;
            Block.assignType(nArray, i, 3);
        }
    }

    private void lookForVariableAccess(OptFunctionNode optFunctionNode, Node node) {
        switch (node.getType()) {
            case 141: {
                int n = optFunctionNode.fnode.getIndexForNameNode(node);
                if (n <= -1 || this.itsNotDefSet.get(n)) break;
                this.itsUseBeforeDefSet.set(n);
                break;
            }
            case 110: 
            case 111: {
                Node node2 = node.getFirstChild();
                if (node2.getType() == 55) {
                    int n = optFunctionNode.getVarIndex(node2);
                    if (!this.itsNotDefSet.get(n)) {
                        this.itsUseBeforeDefSet.set(n);
                    }
                    this.itsNotDefSet.set(n);
                    break;
                }
                this.lookForVariableAccess(optFunctionNode, node2);
                break;
            }
            case 56: 
            case 160: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                this.lookForVariableAccess(optFunctionNode, node4);
                this.itsNotDefSet.set(optFunctionNode.getVarIndex(node));
                break;
            }
            case 55: {
                int n = optFunctionNode.getVarIndex(node);
                if (this.itsNotDefSet.get(n)) break;
                this.itsUseBeforeDefSet.set(n);
                break;
            }
            default: {
                for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNext()) {
                    this.lookForVariableAccess(optFunctionNode, node5);
                }
            }
        }
    }

    private void initLiveOnEntrySets(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n = optFunctionNode.getVarCount();
        this.itsUseBeforeDefSet = new BitSet(n);
        this.itsNotDefSet = new BitSet(n);
        this.itsLiveOnEntrySet = new BitSet(n);
        this.itsLiveOnExitSet = new BitSet(n);
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = nodeArray[i];
            this.lookForVariableAccess(optFunctionNode, node);
        }
        this.itsNotDefSet.flip(0, n);
    }

    private boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            for (Block block : this.itsSuccessors) {
                this.itsLiveOnExitSet.or(block.itsLiveOnEntrySet);
            }
        }
        return Block.updateEntrySet(this.itsLiveOnEntrySet, this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    private static boolean updateEntrySet(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        int n = bitSet.cardinality();
        bitSet.or(bitSet2);
        bitSet.and(bitSet4);
        bitSet.or(bitSet3);
        return bitSet.cardinality() != n;
    }

    private static int findExpressionType(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        switch (node.getType()) {
            case 40: {
                return 1;
            }
            case 30: 
            case 38: 
            case 71: {
                return 3;
            }
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                return 3;
            }
            case 55: {
                return nArray[optFunctionNode.getVarIndex(node)];
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 75: 
            case 110: 
            case 111: {
                return 1;
            }
            case 130: {
                return 3;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 70: {
                return 3;
            }
            case 32: 
            case 41: 
            case 141: {
                return 3;
            }
            case 42: 
            case 48: 
            case 66: 
            case 67: 
            case 83: 
            case 161: 
            case 170: {
                return 3;
            }
            case 21: {
                Node node2 = node.getFirstChild();
                int n = Block.findExpressionType(optFunctionNode, node2, nArray);
                int n2 = Block.findExpressionType(optFunctionNode, node2.getNext(), nArray);
                return n | n2;
            }
            case 106: {
                Node node3 = node.getFirstChild().getNext();
                Node node4 = node3.getNext();
                int n = Block.findExpressionType(optFunctionNode, node3, nArray);
                int n3 = Block.findExpressionType(optFunctionNode, node4, nArray);
                return n | n3;
            }
            case 8: 
            case 35: 
            case 37: 
            case 56: 
            case 92: 
            case 160: {
                return Block.findExpressionType(optFunctionNode, node.getLastChild(), nArray);
            }
            case 108: 
            case 109: {
                Node node5 = node.getFirstChild();
                int n = Block.findExpressionType(optFunctionNode, node5, nArray);
                int n4 = Block.findExpressionType(optFunctionNode, node5.getNext(), nArray);
                return n | n4;
            }
        }
        return 3;
    }

    private static boolean findDefPoints(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        Node node2;
        Node node3;
        boolean bl = false;
        for (node3 = node2 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            bl |= Block.findDefPoints(optFunctionNode, node3, nArray);
        }
        switch (node.getType()) {
            case 110: 
            case 111: {
                if (node2.getType() != 55) break;
                int n = optFunctionNode.getVarIndex(node2);
                if (optFunctionNode.fnode.getParamAndVarConst()[n]) break;
                bl |= Block.assignType(nArray, n, 1);
                break;
            }
            case 56: 
            case 160: {
                node3 = node2.getNext();
                int n = Block.findExpressionType(optFunctionNode, node3, nArray);
                int n2 = optFunctionNode.getVarIndex(node);
                if (node.getType() == 56 && optFunctionNode.fnode.getParamAndVarConst()[n2]) break;
                bl |= Block.assignType(nArray, n2, n);
                break;
            }
        }
        return bl;
    }

    private boolean doTypeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, int[] nArray) {
        boolean bl = false;
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = nodeArray[i];
            if (node == null) continue;
            bl |= Block.findDefPoints(optFunctionNode, node, nArray);
        }
        return bl;
    }

    private void printLiveOnEntrySet(OptFunctionNode optFunctionNode) {
    }

    private static class FatBlock {
        private ObjToIntMap successors = new ObjToIntMap();
        private ObjToIntMap predecessors = new ObjToIntMap();
        Block realBlock;

        private FatBlock() {
        }

        private static Block[] reduceToArray(ObjToIntMap objToIntMap) {
            Block[] blockArray = null;
            if (!objToIntMap.isEmpty()) {
                blockArray = new Block[objToIntMap.size()];
                int n = 0;
                ObjToIntMap.Iterator iterator = objToIntMap.newIterator();
                iterator.start();
                while (!iterator.done()) {
                    FatBlock fatBlock = (FatBlock)iterator.getKey();
                    blockArray[n++] = fatBlock.realBlock;
                    iterator.next();
                }
            }
            return blockArray;
        }

        void addSuccessor(FatBlock fatBlock) {
            this.successors.put(fatBlock, 0);
        }

        void addPredecessor(FatBlock fatBlock) {
            this.predecessors.put(fatBlock, 0);
        }

        Block[] getSuccessors() {
            return FatBlock.reduceToArray(this.successors);
        }

        Block[] getPredecessors() {
            return FatBlock.reduceToArray(this.predecessors);
        }
    }
}

