# frozen_string_literal: true

# Placeholder class for model that is implemented in EE
class Vulnerability < ::SecApplicationRecord
  include EachBatch
  include AfterCommitQueue
  include IgnorableColumns

  alias_attribute :vulnerability_id, :id

  scope :with_projects, -> { preload(:project) }

  validates :cvss, json_schema: { filename: "vulnerability_cvss_vectors" }
  attribute :cvss, ::Gitlab::Database::Type::IndifferentJsonb.new

  def self.link_reference_pattern
    nil
  end

  def self.reference_prefix
    '[vulnerability:'
  end

  def self.reference_postfix
    ']'
  end
end

Vulnerability.prepend_mod
