# frozen_string_literal: true

class AddForeignKeyToVulnerabilityOccurrencesOnSecretDetectionTokenStatus < Gitlab::Database::Migration[2.2]
  milestone '17.11'
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :secret_detection_token_statuses, :vulnerability_occurrences,
      column: :vulnerability_occurrence_id, on_delete: :cascade, reverse_lock_order: true
  end

  def down
    with_lock_retries do
      remove_foreign_key_if_exists :secret_detection_token_statuses, column: :vulnerability_occurrence_id,
        reverse_lock_order: true
    end
  end
end
