/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.support.EntityManagers;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public abstract class RealmMigration
implements Migration {
    private static final Logger LOG = Logger.getLogger(RealmMigration.class);

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> {
            EntityManagers.flush((KeycloakSession)session, (boolean)true);
            KeycloakContext context = session.getContext();
            RealmModel oldRealm = session.getContext().getRealm();
            RealmModel mutableRealm = session.realms().getRealmByName(realm.getName());
            try {
                context.setRealm(mutableRealm);
                this.migrateRealm(session, mutableRealm);
                LOG.infof("migrated realm %s to %s", (Object)realm.getName(), (Object)this.getVersion());
            }
            finally {
                context.setRealm(oldRealm);
            }
        });
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    public abstract void migrateRealm(KeycloakSession var1, RealmModel var2);
}

