/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.console.StatusLine;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class StartupLogCompressor
implements Closeable,
BiPredicate<String, Boolean> {
    final Thread thread;
    final String name;
    final StatusLine sl;
    final List<String> toDump = new ArrayList<String>();
    final AtomicInteger COUNTER = new AtomicInteger();
    final Predicate<Thread> additionalThreadPredicate;
    final Predicate<String> linePredicate;

    public StartupLogCompressor(String name, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        this(name, consoleInstalledBuildItem, loggingSetupBuildItem, s -> false);
    }

    public StartupLogCompressor(String name, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, Predicate<Thread> additionalThreadPredicate) {
        this(name, consoleInstalledBuildItem, loggingSetupBuildItem, additionalThreadPredicate, s -> false);
    }

    public StartupLogCompressor(String name, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, Predicate<Thread> additionalThreadPredicate, Predicate<String> linePredicate) {
        this.additionalThreadPredicate = Objects.requireNonNull(additionalThreadPredicate);
        this.linePredicate = Objects.requireNonNull(linePredicate);
        if (QuarkusConsole.INSTANCE.isAnsiSupported()) {
            QuarkusConsole.installRedirects();
            this.name = name;
            this.thread = Thread.currentThread();
            QuarkusConsole.addOutputFilter((BiPredicate)this);
            this.sl = QuarkusConsole.INSTANCE.registerStatusLine(1000 + this.COUNTER.incrementAndGet());
            this.sl.setMessage("\u001b[94m" + name + "\u001b[39m");
        } else {
            this.thread = null;
            this.name = null;
            this.sl = null;
        }
    }

    @Override
    public void close() {
        if (this.thread == null) {
            return;
        }
        QuarkusConsole.removeOutputFilter((BiPredicate)this);
        if (this.sl != null) {
            this.sl.close();
        }
    }

    public void closeAndDumpCaptured() {
        if (this.thread == null) {
            return;
        }
        QuarkusConsole.removeOutputFilter((BiPredicate)this);
        if (this.sl != null) {
            this.sl.close();
        }
        for (String i : this.toDump) {
            QuarkusConsole.INSTANCE.write(true, i);
        }
    }

    @Override
    public boolean test(String s, Boolean errorStream) {
        if (this.thread == null || this.linePredicate.test(s)) {
            return true;
        }
        Thread current = Thread.currentThread();
        if (current == this.thread || this.additionalThreadPredicate.test(current)) {
            this.toDump.add(s);
            if (this.sl != null) {
                this.sl.setMessage("\u001b[94m" + this.name + "\u001b[39m " + s.replace("\n", ""));
            }
            return false;
        }
        return true;
    }
}

