/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest.mappers;

import java.util.Map;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.indices.pollingingest.IngestionUtils;
import org.opensearch.indices.pollingingest.ShardUpdateMessage;
import org.opensearch.indices.pollingingest.mappers.IngestionMessageMapper;

public class RawPayloadIngestionMessageMapper
implements IngestionMessageMapper {
    private static final String OP_TYPE_INDEX = "index";
    private final int shardId;

    public RawPayloadIngestionMessageMapper(int shardId) {
        this.shardId = shardId;
    }

    @Override
    public ShardUpdateMessage mapAndProcess(IngestionShardPointer pointer, Message message) throws IllegalArgumentException {
        Map<String, Object> sourceMap = IngestionUtils.getParsedPayloadMap((byte[])message.getPayload());
        String id = this.shardId + "-" + pointer.asString();
        long autoGeneratedIdTimestamp = -1L;
        Map<String, Object> payloadMap = Map.of("_id", id, "_op_type", OP_TYPE_INDEX, "_source", sourceMap);
        return new ShardUpdateMessage<IngestionShardPointer, Message>(pointer, message, payloadMap, autoGeneratedIdTimestamp);
    }
}

